/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.util.Objects;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.IsisAssertException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterByIdProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facets.object.callbacks.LifecycleEventFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.memento.Data;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_DependencyInjection;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_Factories;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_LifecycleEventSupport;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_MementoSupport;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_NewIdentifier;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_ObjectAdapterByIdProvider;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_ObjectAdapterProvider;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_ObjectCreation;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext_ServiceLookup;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectAdapterContext {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext.class);
    private final PersistenceSession persistenceSession;
    private final SpecificationLoader specificationLoader;
    private final ObjectAdapterContext_ObjectAdapterProvider objectAdapterProviderMixin;
    private final ObjectAdapterContext_MementoSupport mementoSupportMixin;
    private final ObjectAdapterContext_ServiceLookup serviceLookupMixin;
    private final ObjectAdapterContext_NewIdentifier newIdentifierMixin;
    private final ObjectAdapterContext_ObjectAdapterByIdProvider objectAdapterByIdProviderMixin;
    private final ObjectAdapterContext_DependencyInjection dependencyInjectionMixin;
    final ObjectAdapterContext_ObjectCreation objectCreationMixin;
    private final ObjectAdapterContext_LifecycleEventSupport lifecycleEventMixin;
    private final ServicesInjector servicesInjector;
    private final ObjectAdapterFactories objectAdapterFactories;

    public static ObjectAdapterContext openContext(ServicesInjector servicesInjector, AuthenticationSession authenticationSession, SpecificationLoader specificationLoader, PersistenceSession persistenceSession) {
        ObjectAdapterContext objectAdapterContext = new ObjectAdapterContext(servicesInjector, authenticationSession, specificationLoader, persistenceSession);
        objectAdapterContext.open();
        return objectAdapterContext;
    }

    private ObjectAdapterContext(ServicesInjector servicesInjector, AuthenticationSession authenticationSession, SpecificationLoader specificationLoader, PersistenceSession persistenceSession) {
        this.objectAdapterProviderMixin = new ObjectAdapterContext_ObjectAdapterProvider(this, persistenceSession);
        this.mementoSupportMixin = new ObjectAdapterContext_MementoSupport(this, persistenceSession);
        this.serviceLookupMixin = new ObjectAdapterContext_ServiceLookup(this, servicesInjector);
        this.newIdentifierMixin = new ObjectAdapterContext_NewIdentifier(this, persistenceSession);
        this.objectAdapterByIdProviderMixin = new ObjectAdapterContext_ObjectAdapterByIdProvider(this, persistenceSession, authenticationSession);
        this.dependencyInjectionMixin = new ObjectAdapterContext_DependencyInjection(this, persistenceSession);
        this.objectCreationMixin = new ObjectAdapterContext_ObjectCreation(this, persistenceSession);
        this.lifecycleEventMixin = new ObjectAdapterContext_LifecycleEventSupport(this, persistenceSession);
        this.persistenceSession = persistenceSession;
        this.specificationLoader = specificationLoader;
        this.servicesInjector = servicesInjector;
        this.objectAdapterFactories = new ObjectAdapterContext_Factories(authenticationSession, specificationLoader, persistenceSession);
    }

    void printContextInfo(String msg) {
        if (LOG.isDebugEnabled()) {
            String id = Integer.toHexString(this.hashCode());
            String session = "" + this.persistenceSession;
            LOG.debug(String.format("%s id=%s session='%s'", msg, id, session));
        }
    }

    private void open() {
        this.printContextInfo("OPEN_");
    }

    public void close() {
        this.printContextInfo("CLOSE");
    }

    public RootOid createPersistentOrViewModelOid(Object pojo) {
        return this.newIdentifierMixin.createPersistentOid(pojo);
    }

    ObjectAdapter lookupServiceAdapterFor(RootOid rootOid) {
        return this.serviceLookupMixin.lookupServiceAdapterFor(rootOid);
    }

    public ObjectAdapterByIdProvider getObjectAdapterByIdProvider() {
        return this.objectAdapterByIdProviderMixin;
    }

    Object instantiateAndInjectServices(ObjectSpecification objectSpec) {
        return this.dependencyInjectionMixin.instantiateAndInjectServices(objectSpec);
    }

    ObjectAdapterFactories getFactories() {
        return this.objectAdapterFactories;
    }

    public ObjectAdapter fetchPersistent(Object pojo) {
        if (this.persistenceSession.getPersistenceManager().getObjectId(pojo) == null) {
            return null;
        }
        RootOid oid = this.createPersistentOrViewModelOid(pojo);
        ObjectAdapter adapter = this.recreatePojo((Oid)oid, pojo);
        return adapter;
    }

    public ObjectAdapter recreatePojo(Oid oid, Object recreatedPojo) {
        ObjectAdapter createdAdapter = this.createRootOrAggregatedAdapter(oid, recreatedPojo);
        return this.injectServices(createdAdapter);
    }

    ObjectAdapter injectServices(ObjectAdapter adapter) {
        Objects.requireNonNull(adapter);
        if (adapter.isValue()) {
            return adapter;
        }
        Object pojo = adapter.getPojo();
        this.servicesInjector.injectServicesInto(pojo);
        return adapter;
    }

    ObjectAdapter createRootOrAggregatedAdapter(Oid oid, Object pojo) {
        ObjectAdapter createdAdapter;
        if (oid instanceof RootOid) {
            RootOid rootOid = (RootOid)oid;
            createdAdapter = this.getFactories().createRootAdapter(pojo, rootOid);
        } else {
            ParentedOid collectionOid = (ParentedOid)oid;
            createdAdapter = this.getFactories().createCollectionAdapter(pojo, collectionOid);
        }
        return createdAdapter;
    }

    public ObjectAdapterProvider getObjectAdapterProvider() {
        return this.objectAdapterProviderMixin;
    }

    public MementoRecreateObjectSupport mementoSupport() {
        return this.mementoSupportMixin;
    }

    public void postLifecycleEventIfRequired(ManagedObject adapter, Class<? extends LifecycleEventFacet> lifecycleEventFacetClass) {
        this.lifecycleEventMixin.postLifecycleEventIfRequired(adapter, lifecycleEventFacetClass);
    }

    ObjectAdapter adapterForViewModel(Object viewModelPojo, String mementoString) {
        ObjectSpecification objectSpecification = this.specificationLoader.loadSpecification(viewModelPojo.getClass());
        ObjectSpecId objectSpecId = objectSpecification.getSpecId();
        RootOid newRootOid = Oid.Factory.viewmodelOf((ObjectSpecId)objectSpecId, (String)mementoString);
        ObjectAdapter viewModelAdapter = this.recreatePojo((Oid)newRootOid, viewModelPojo);
        return viewModelAdapter;
    }

    public void asPersistent(ObjectAdapter rootAdapter, PersistenceSession session) {
        ObjectSpecId adapterObjectSpecId;
        RootOid persistentOid = this.createPersistentOrViewModelOid(rootAdapter.getPojo());
        Objects.requireNonNull(persistentOid);
        Assert.assertFalse((String)"expected to not be a parented collection", (boolean)rootAdapter.isParentedCollection());
        if (persistentOid.isTransient()) {
            throw new IsisAssertException("hintRootOid must be persistent");
        }
        ObjectSpecId hintRootOidObjectSpecId = persistentOid.getObjectSpecId();
        if (!hintRootOidObjectSpecId.equals((Object)(adapterObjectSpecId = rootAdapter.getSpecification().getSpecId()))) {
            throw new IsisAssertException("hintRootOid's objectType must be same as that of adapter (was: '" + hintRootOidObjectSpecId + "'; adapter's is " + adapterObjectSpecId + "'");
        }
    }

    public static interface MementoRecreateObjectSupport {
        public ObjectAdapter recreateObject(ObjectSpecification var1, Oid var2, Data var3);
    }

    static interface ObjectAdapterFactories {
        public ObjectAdapter createRootAdapter(Object var1, RootOid var2);

        public ObjectAdapter createCollectionAdapter(Object var1, ParentedOid var2);

        public ObjectAdapter createCollectionAdapter(Object var1, RootOid var2, OneToManyAssociation var3);
    }
}

