/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.services.changes.ChangedObjectsServiceInternal;
import org.apache.isis.core.runtime.system.persistence.PersistenceQueryFactory;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PersistenceSessionBase
implements PersistenceSession {
    protected static final Logger LOG = LoggerFactory.getLogger(PersistenceSession.class);
    protected final FixturesInstalledFlag fixturesInstalledFlag;
    protected final PersistenceQueryFactory persistenceQueryFactory;
    protected final IsisConfiguration configuration;
    protected final SpecificationLoader specificationLoader;
    protected final AuthenticationSession authenticationSession;
    protected final ServicesInjector servicesInjector;
    protected final CommandContext commandContext;
    protected final CommandService commandService;
    protected final InteractionContext interactionContext;
    protected final ChangedObjectsServiceInternal changedObjectsServiceInternal;
    protected final FactoryService factoryService;
    protected final MetricsService metricsService;
    protected final ClockService clockService;
    protected final UserService userService;
    protected long openedAtSystemNanos = -1L;
    protected final PersistenceManagerFactory jdoPersistenceManagerFactory;
    protected IsisTransactionManager transactionManager;
    protected PersistenceManager persistenceManager;
    protected final Map<Class<?>, PersistenceQueryProcessor<?>> persistenceQueryProcessorByClass = _Maps.newHashMap();
    protected State state;

    protected PersistenceSessionBase(ServicesInjector servicesInjector, AuthenticationSession authenticationSession, PersistenceManagerFactory jdoPersistenceManagerFactory, FixturesInstalledFlag fixturesInstalledFlag) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating {}", (Object)this);
        }
        this.servicesInjector = servicesInjector;
        this.jdoPersistenceManagerFactory = jdoPersistenceManagerFactory;
        this.fixturesInstalledFlag = fixturesInstalledFlag;
        this.configuration = _Config.getConfiguration();
        this.specificationLoader = servicesInjector.getSpecificationLoader();
        this.authenticationSession = authenticationSession;
        this.commandContext = this.lookupService(CommandContext.class);
        this.commandService = this.lookupService(CommandService.class);
        this.interactionContext = this.lookupService(InteractionContext.class);
        this.changedObjectsServiceInternal = this.lookupService(ChangedObjectsServiceInternal.class);
        this.metricsService = this.lookupService(MetricsService.class);
        this.factoryService = this.lookupService(FactoryService.class);
        this.clockService = this.lookupService(ClockService.class);
        this.userService = this.lookupService(UserService.class);
        this.persistenceQueryFactory = new PersistenceQueryFactory(obj -> this.getObjectAdapterProvider().adapterFor(obj), this.specificationLoader);
        this.transactionManager = new IsisTransactionManager(this, servicesInjector);
        this.state = State.NOT_INITIALIZED;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    @Override
    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    @Override
    public IsisTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public long getLifecycleStartedAtSystemNanos() {
        return this.openedAtSystemNanos;
    }

    protected void ensureNotOpened() {
        if (this.state != State.NOT_INITIALIZED) {
            throw new IllegalStateException("Persistence session has already been initialized");
        }
    }

    protected void ensureOpened() {
        this.ensureStateIs(State.OPEN);
    }

    private void ensureStateIs(State stateRequired) {
        if (this.state == stateRequired) {
            return;
        }
        throw new IllegalStateException("State is: " + (Object)((Object)this.state) + "; should be: " + (Object)((Object)stateRequired));
    }

    @Override
    public void startTransaction() {
        Transaction transaction = this.persistenceManager.currentTransaction();
        if (transaction.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        transaction.begin();
    }

    @Override
    public void endTransaction() {
        Transaction transaction = this.persistenceManager.currentTransaction();
        if (transaction.isActive()) {
            transaction.commit();
        }
    }

    @Override
    public void abortTransaction() {
        Transaction transaction = this.persistenceManager.currentTransaction();
        if (transaction.isActive()) {
            transaction.rollback();
        }
    }

    private <T> T lookupService(Class<T> serviceType) {
        T service = this.lookupServiceIfAny(serviceType);
        if (service == null) {
            throw new IllegalStateException("Could not locate service of type '" + serviceType + "'");
        }
        return service;
    }

    private <T> T lookupServiceIfAny(Class<T> serviceType) {
        return this.servicesInjector.lookupService(serviceType).orElse(null);
    }

    protected <T> List<T> lookupServices(Class<T> serviceClass) {
        return this.servicesInjector.streamServices(serviceClass).collect(Collectors.toList());
    }

    public String toString() {
        return new ToString((Object)this).toString();
    }

    protected static enum State {
        NOT_INITIALIZED,
        OPEN,
        CLOSED;

    }

    protected static enum Type {
        TRANSIENT,
        PERSISTENT;

    }
}

