/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceQueryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceQueryFactory.class);
    private final SpecificationLoader specificationLoader;
    private final Function<Object, ObjectAdapter> adapterProvider;

    PersistenceQueryFactory(Function<Object, ObjectAdapter> adapterProvider, SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
        this.adapterProvider = adapterProvider;
    }

    final PersistenceQuery createPersistenceQueryFor(Query<?> query, QueryCardinality cardinality) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPersistenceQueryFor: {}", (Object)query.getDescription());
        }
        ObjectSpecification noSpec = this.specFor(query);
        if (query instanceof QueryFindAllInstances) {
            QueryFindAllInstances queryFindAllInstances = (QueryFindAllInstances)query;
            return new PersistenceQueryFindAllInstances(noSpec, queryFindAllInstances.getStart(), queryFindAllInstances.getCount());
        }
        QueryDefault queryDefault = (QueryDefault)query;
        String queryName = queryDefault.getQueryName();
        Map<String, ObjectAdapter> argumentsAdaptersByParameterName = this.wrap(queryDefault.getArgumentsByParameterName());
        return new PersistenceQueryFindUsingApplibQueryDefault(noSpec, queryName, argumentsAdaptersByParameterName, cardinality, this.specificationLoader, queryDefault.getStart(), queryDefault.getCount());
    }

    private Map<String, ObjectAdapter> wrap(Map<String, Object> argumentsByParameterName) {
        HashMap argumentsAdaptersByParameterName = _Maps.newHashMap();
        for (Map.Entry<String, Object> entry : argumentsByParameterName.entrySet()) {
            String parameterName = entry.getKey();
            Object argument = argumentsByParameterName.get(parameterName);
            ObjectAdapter argumentAdapter = argument != null ? this.adapterProvider.apply(argument) : null;
            argumentsAdaptersByParameterName.put(parameterName, argumentAdapter);
        }
        return argumentsAdaptersByParameterName;
    }

    private ObjectSpecification specFor(Query<?> query) {
        return this.specificationLoader.loadSpecification(query.getResultType());
    }
}

