/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.persistsession;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.xactn.Transaction;
import org.apache.isis.applib.services.xactn.TransactionState;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483646")
public class PersistenceSessionServiceInternalDefault
implements PersistenceSessionServiceInternal {
    @Inject
    IsisSessionFactory isisSessionFactory;

    public ObjectAdapterProvider getObjectAdapterProvider() {
        return this.getPersistenceSession();
    }

    public void makePersistent(ObjectAdapter adapter) {
        this.getPersistenceSession().makePersistentInTransaction(adapter);
    }

    public void remove(ObjectAdapter adapter) {
        this.getPersistenceSession().destroyObjectInTransaction(adapter);
    }

    public ObjectAdapter createTransientInstance(ObjectSpecification spec) {
        return this.getPersistenceSession().newTransientInstance(spec);
    }

    public ObjectAdapter createViewModelInstance(ObjectSpecification spec, String memento) {
        return this.getPersistenceSession().recreateViewModelInstance(spec, memento);
    }

    public Object lookup(Bookmark bookmark, BookmarkService.FieldResetPolicy fieldResetPolicy) {
        boolean denyRefresh;
        RootOid rootOid = Oid.Factory.ofBookmark((Bookmark)bookmark);
        PersistenceSession ps = this.getPersistenceSession();
        boolean bl = denyRefresh = fieldResetPolicy == BookmarkService.FieldResetPolicy.DONT_REFRESH;
        if (rootOid.isViewModel()) {
            ObjectAdapter adapter = ps.adapterFor(rootOid, ConcurrencyChecking.NO_CHECK);
            Object pojo = _With.mapIfPresentElse((Object)adapter, ManagedObject::getPojo, null);
            return pojo;
        }
        if (denyRefresh) {
            Object pojo = ps.fetchPersistentPojoInTransaction(rootOid);
            return pojo;
        }
        ObjectAdapter adapter = ps.adapterFor(rootOid, ConcurrencyChecking.NO_CHECK);
        Object pojo = _With.mapIfPresentElse((Object)adapter, ManagedObject::getPojo, null);
        _With.acceptIfPresent((Object)pojo, ps::refreshRootInTransaction);
        return pojo;
    }

    public Bookmark bookmarkFor(Object domainObject) {
        ObjectAdapter adapter = this.getPersistenceSession().adapterFor(domainObject);
        if (adapter.isValue()) {
            return null;
        }
        Oid oid = adapter.getOid();
        if (!(oid instanceof RootOid)) {
            return null;
        }
        RootOid rootOid = (RootOid)oid;
        return rootOid.asBookmark();
    }

    public Bookmark bookmarkFor(Class<?> cls, String identifier) {
        ObjectSpecification objectSpec = this.getSpecificationLoader().loadSpecification(cls);
        String objectType = objectSpec.getSpecId().asString();
        return new Bookmark(objectType, identifier);
    }

    public void resolve(Object parent) {
        this.getPersistenceSession().refreshRootInTransaction(parent);
    }

    public void beginTran() {
        this.beginTran(null);
    }

    public void beginTran(Command commandIfAny) {
        this.getTransactionManager().startTransaction(commandIfAny);
    }

    public boolean flush() {
        return this.getTransactionManager().flushTransaction();
    }

    public void commit() {
        this.getTransactionManager().endTransaction();
    }

    public void abortTransaction() {
        this.getTransactionManager().abortTransaction();
    }

    public Transaction currentTransaction() {
        return this.getTransactionManager().getCurrentTransaction();
    }

    public CountDownLatch currentTransactionLatch() {
        IsisTransaction transaction = this.getTransactionManager().getCurrentTransaction();
        return transaction == null ? new CountDownLatch(0) : transaction.countDownLatch();
    }

    public <T> List<ObjectAdapter> allMatchingQuery(Query<T> query) {
        return this.getPersistenceSession().allMatchingQuery(query);
    }

    public <T> ObjectAdapter firstMatchingQuery(Query<T> query) {
        return this.getPersistenceSession().firstMatchingQuery(query);
    }

    public void executeWithinTransaction(Runnable task) {
        this.getTransactionManager().executeWithinTransaction(task);
    }

    public <T> T executeWithinTransaction(Supplier<T> task) {
        return this.getTransactionManager().executeWithinTransaction(task);
    }

    public TransactionState getTransactionState() {
        IsisTransaction transaction = this.getTransactionManager().getCurrentTransaction();
        if (transaction == null) {
            return TransactionState.NONE;
        }
        IsisTransaction.State state = transaction.getState();
        return state.getTransactionState();
    }

    protected PersistenceSession getPersistenceSession() {
        return Optional.ofNullable(this.getIsisSessionFactory().getCurrentSession()).map(IsisSession::getPersistenceSession).orElseThrow(() -> new NonRecoverableException("No IsisSession on current thread."));
    }

    private IsisSessionFactory getIsisSessionFactory() {
        return Objects.requireNonNull(this.isisSessionFactory, "IsisSessionFactory was not injected.");
    }

    @Programmatic
    public IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }
}

