/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.isis.applib.services.background.BackgroundCommandService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.schema.cmd.v1.CommandDto;

class CommandInvocationHandler<T>
implements InvocationHandler {
    private final BackgroundCommandService backgroundCommandService;
    private final T target;
    private final Object mixedInIfAny;
    private final SpecificationLoader specificationLoader;
    private final CommandDtoServiceInternal commandDtoServiceInternal;
    private final CommandContext commandContext;
    private final Supplier<ObjectAdapterProvider> adapterProviderSupplier;

    CommandInvocationHandler(BackgroundCommandService backgroundCommandService, T target, Object mixedInIfAny, SpecificationLoader specificationLoader, CommandDtoServiceInternal commandDtoServiceInternal, CommandContext commandContext, Supplier<ObjectAdapterProvider> adapterProviderSupplier) {
        this.backgroundCommandService = (BackgroundCommandService)_With.requires((Object)backgroundCommandService, (String)"backgroundCommandService");
        this.target = _With.requires(target, (String)"target");
        this.mixedInIfAny = mixedInIfAny;
        this.specificationLoader = (SpecificationLoader)_With.requires((Object)specificationLoader, (String)"specificationLoader");
        this.commandDtoServiceInternal = (CommandDtoServiceInternal)_With.requires((Object)commandDtoServiceInternal, (String)"commandDtoServiceInternal");
        this.commandContext = (CommandContext)_With.requires((Object)commandContext, (String)"commandContext");
        this.adapterProviderSupplier = (Supplier)_With.requires(adapterProviderSupplier, (String)"adapterProviderSupplier");
    }

    @Override
    public Object invoke(Object proxied, Method proxyMethod, Object[] args) throws Throwable {
        Object domainObject;
        boolean inheritedFromObject = proxyMethod.getDeclaringClass().equals(Object.class);
        if (inheritedFromObject) {
            return proxyMethod.invoke(this.target, args);
        }
        ObjectSpecificationDefault targetObjSpec = this.getJavaSpecificationOfOwningClass(proxyMethod);
        ObjectMember member = targetObjSpec.getMember(proxyMethod);
        if (member == null) {
            return proxyMethod.invoke(this.target, args);
        }
        if (!(member instanceof ObjectAction)) {
            throw new UnsupportedOperationException("Only actions can be executed in the background (method " + proxyMethod.getName() + " represents a " + member.getFeatureType().name() + "')");
        }
        ObjectAction action = (ObjectAction)member;
        if (this.mixedInIfAny == null) {
            domainObject = this.target;
        } else {
            domainObject = this.mixedInIfAny;
            action = this.findMixedInAction(action, this.mixedInIfAny);
        }
        ObjectAdapter domainObjectAdapter = this.getObjectAdapterProvider().adapterFor(domainObject);
        String domainObjectClassName = CommandUtil.targetClassNameFor((ObjectAdapter)domainObjectAdapter);
        String targetActionName = CommandUtil.targetMemberNameFor((ObjectMember)action);
        ObjectAdapter[] argAdapters = this.adaptersFor(args);
        String targetArgs = CommandUtil.argDescriptionFor((ObjectAction)action, (ObjectAdapter[])argAdapters);
        Command command = this.commandContext.getCommand();
        List<ObjectAdapter> targetList = Collections.singletonList(domainObjectAdapter);
        CommandDto dto = this.commandDtoServiceInternal.asCommandDto(targetList, action, argAdapters);
        this.backgroundCommandService.schedule(dto, command, domainObjectClassName, targetActionName, targetArgs);
        return null;
    }

    private ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProviderSupplier.get();
    }

    private ObjectAction findMixedInAction(ObjectAction action, Object domainObject) {
        String actionId = action.getId();
        ObjectSpecification domainSpec = this.getObjectAdapterProvider().adapterFor(domainObject).getSpecification();
        Stream objectActions = domainSpec.streamObjectActions(Contributed.INCLUDED);
        return (ObjectAction)objectActions.filter(objectAction -> objectAction instanceof ObjectActionMixedIn).map(objectAction -> (ObjectActionMixedIn)objectAction).filter(objectActionMixedIn -> objectActionMixedIn.hasMixinAction(action)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unable to find mixin action '%s' for %s", actionId, domainSpec.getFullIdentifier())));
    }

    private ObjectAdapter[] adaptersFor(Object[] args) {
        ObjectAdapterProvider adapterProvider = this.getObjectAdapterProvider();
        return CommandUtil.adaptersFor((Object[])args, (ObjectAdapterProvider)adapterProvider);
    }

    private ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private ObjectSpecificationDefault getJavaSpecification(Class<?> cls) {
        ObjectSpecification objectSpec = this.getSpecification(cls);
        if (!(objectSpec instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + objectSpec.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)objectSpec;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        return this.specificationLoader.loadSpecification(type);
    }
}

