/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import java.lang.reflect.InvocationHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.background.BackgroundCommandService;
import org.apache.isis.applib.services.background.BackgroundService;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ProxyEnhanced;
import org.apache.isis.core.plugins.codegen.ProxyFactory;
import org.apache.isis.core.runtime.services.background.CommandInvocationHandler;
import org.apache.isis.core.runtime.services.background.ForkingInvocationHandler;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class BackgroundServiceDefault
implements BackgroundService {
    static final Logger LOG = LoggerFactory.getLogger(BackgroundServiceDefault.class);
    private BuiltinExecutor builtinExecutor;
    @Inject
    private BackgroundCommandService backgroundCommandService;
    @Inject
    private CommandDtoServiceInternal commandDtoServiceInternal;
    @Inject
    private CommandContext commandContext;
    @Inject
    private FactoryService factoryService;
    @Inject
    private SpecificationLoader specificationLoader;
    @Inject
    private IsisSessionFactory isisSessionFactory;

    private boolean usesBuiltinExecutor() {
        return this.backgroundCommandService == null;
    }

    @Programmatic
    @PostConstruct
    public void init() {
        if (this.usesBuiltinExecutor()) {
            this.builtinExecutor = new BuiltinExecutor();
        }
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
        if (this.builtinExecutor != null) {
            this.builtinExecutor.shutdown();
        }
    }

    ObjectSpecification getSpecification(Class<?> type) {
        return this.specificationLoader.loadSpecification(type);
    }

    @Programmatic
    public <T> T execute(T domainObject) {
        Class cls = (Class)_Casts.uncheckedCast(domainObject.getClass());
        InvocationHandler methodHandler = this.newMethodHandler(domainObject, null);
        return this.newProxy(cls, null, methodHandler);
    }

    public <T> T executeMixin(Class<T> mixinClass, Object mixedIn) {
        Object mixin = this.factoryService.mixin(mixinClass, mixedIn);
        InvocationHandler methodHandler = this.newMethodHandler(mixin, mixedIn);
        return this.newProxy(mixinClass, mixedIn, methodHandler);
    }

    private <T> T newProxy(Class<T> cls, Object mixedInIfAny, InvocationHandler methodHandler) {
        Object[] objectArray;
        Class[] constructorArgTypes;
        Class[] classArray;
        boolean initialize;
        Class[] interfaces = (Class[])ArrayExtensions.combine((Object[][])new Class[][]{cls.getInterfaces(), {ProxyEnhanced.class}});
        boolean bl = initialize = mixedInIfAny != null;
        if (initialize) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = mixedInIfAny.getClass();
        } else {
            classArray = constructorArgTypes = _Constants.emptyClasses;
        }
        if (initialize) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = mixedInIfAny;
        } else {
            objectArray = _Constants.emptyObjects;
        }
        Object[] constructorArgs = objectArray;
        ProxyFactory proxyFactory = ProxyFactory.builder(cls).interfaces(interfaces).constructorArgTypes(constructorArgTypes).build();
        return (T)(initialize ? proxyFactory.createInstance(methodHandler, constructorArgs) : proxyFactory.createInstance(methodHandler, false));
    }

    private <T> InvocationHandler newMethodHandler(T target, Object mixedInIfAny) {
        if (this.usesBuiltinExecutor()) {
            return new ForkingInvocationHandler<T>(target, mixedInIfAny, this.builtinExecutor.backgroundExecutorService);
        }
        return new CommandInvocationHandler<T>(this.backgroundCommandService, target, mixedInIfAny, this.specificationLoader, this.commandDtoServiceInternal, this.commandContext, this::getObjectAdapterProvider);
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }

    private static class BuiltinExecutor {
        private final int minThreadCount = 1;
        private final int maxThreadCount = 4;
        private final int threadCount = Math.max(1, Math.min(4, Runtime.getRuntime().availableProcessors()));
        public final ExecutorService backgroundExecutorService = Executors.newFixedThreadPool(this.threadCount);

        private BuiltinExecutor() {
        }

        public void shutdown() {
            this.backgroundExecutorService.shutdownNow();
        }
    }
}

