/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.util.DeweyOrderComparator;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstallerAbstract;
import org.apache.isis.core.runtime.services.ServicesInstallerFromAnnotation;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfiguration;
import org.apache.isis.core.runtime.services.ServicesInstallerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInstallerFromConfigurationAndAnnotation
extends ServicesInstallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInstallerFromConfigurationAndAnnotation.class);
    public static final String NAME = "configuration-and-annotation";
    private final ServiceInstantiator serviceInstantiator;
    private final ServicesInstallerFromConfiguration servicesInstallerFromConfiguration;
    private final ServicesInstallerFromAnnotation servicesInstallerFromAnnotation;
    private List<Object> serviceList;

    public ServicesInstallerFromConfigurationAndAnnotation() {
        this(new ServiceInstantiator());
    }

    public ServicesInstallerFromConfigurationAndAnnotation(ServiceInstantiator serviceInstantiator) {
        super(NAME);
        this.serviceInstantiator = serviceInstantiator;
        this.servicesInstallerFromConfiguration = new ServicesInstallerFromConfiguration(serviceInstantiator);
        this.servicesInstallerFromAnnotation = new ServicesInstallerFromAnnotation(serviceInstantiator);
    }

    @Override
    public void init() {
        this.servicesInstallerFromConfiguration.init();
        this.servicesInstallerFromAnnotation.init();
    }

    public void shutdown() {
        this.servicesInstallerFromConfiguration.shutdown();
        this.servicesInstallerFromAnnotation.shutdown();
    }

    @Override
    public List<Object> getServices() {
        LOG.info("installing {}", (Object)this.getClass().getName());
        if (this.serviceList == null) {
            TreeMap positionedServices = _Maps.newTreeMap((Comparator)new DeweyOrderComparator());
            this.servicesInstallerFromConfiguration.appendServices(positionedServices);
            this.servicesInstallerFromAnnotation.appendServices(positionedServices);
            this.serviceList = ServicesInstallerUtils.instantiateServicesFrom(positionedServices, this.serviceInstantiator);
        }
        return this.serviceList;
    }

    public List<Class<?>> getTypes() {
        return ServicesInstallerFromConfigurationAndAnnotation.listOf((Class[])new Class[]{List.class});
    }
}

