/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.objectstore;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Slf4jLogger {
    public static final String PROPERTY_ROOT = "isis.logging.";
    private Logger logger;
    private final LogLevel level;

    public Slf4jLogger() {
        this(LogLevel.DEBUG);
    }

    public Slf4jLogger(String level) {
        this(LogLevel.valueOf(level));
    }

    public Slf4jLogger(LogLevel level) {
        this.level = level;
    }

    protected abstract Class<?> getDecoratedClass();

    protected void log(String message) {
        this.doLog(this.logger(), this.level, message, new Object[0]);
    }

    protected void log(String request, Object result) {
        this.log(request + "  -> " + result);
    }

    protected void doLog(Logger logger, LogLevel level, String format, Object ... argArray) {
        switch (level) {
            case TRACE: {
                logger.trace(format, argArray);
                break;
            }
            case DEBUG: {
                logger.debug(format, argArray);
                break;
            }
            case INFO: {
                logger.info(format, argArray);
                break;
            }
            case WARN: {
                logger.warn(format, argArray);
                break;
            }
            case ERROR: {
                logger.error(format, argArray);
            }
        }
    }

    private Logger logger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getDecoratedClass());
        }
        return this.logger;
    }

    static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

