/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.adapter;

import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PojoAdapter
implements ObjectAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PojoAdapter.class);
    private final AuthenticationSession authenticationSession;
    private final SpecificationLoader specificationLoader;
    private final PersistenceSession persistenceSession;
    private final Object pojo;
    private final Oid oid;
    final _Lazy<ObjectSpecification> objectSpecification = _Lazy.of(this::loadSpecification);

    public static PojoAdapter of(Object pojo, Oid oid, AuthenticationSession authenticationSession, SpecificationLoader specificationLoader, PersistenceSession persistenceSession) {
        return new PojoAdapter(pojo, oid, authenticationSession, specificationLoader, persistenceSession);
    }

    private PojoAdapter(Object pojo, Oid oid, AuthenticationSession authenticationSession, SpecificationLoader specificationLoader, PersistenceSession persistenceSession) {
        this.persistenceSession = persistenceSession;
        this.specificationLoader = specificationLoader;
        this.authenticationSession = authenticationSession;
        if (pojo instanceof ObjectAdapter) {
            throw new IsisException("ObjectAdapter can't be used to wrap an ObjectAdapter: " + pojo);
        }
        if (pojo instanceof Oid) {
            throw new IsisException("ObjectAdapter can't be used to wrap an Oid: " + pojo);
        }
        this.pojo = pojo;
        this.oid = (Oid)_With.requires((Object)oid, (String)"oid");
    }

    public Object getPojo() {
        return this.pojo;
    }

    public ObjectSpecification getSpecification() {
        return (ObjectSpecification)this.objectSpecification.get();
    }

    private ObjectSpecification loadSpecification() {
        Class<?> aClass = this.getPojo().getClass();
        ObjectSpecification specification = this.specificationLoader.loadSpecification(aClass);
        return specification;
    }

    public Oid getOid() {
        return this.oid;
    }

    public boolean isTransient() {
        if (this.getSpecification().isService() || this.getSpecification().isViewModel()) {
            return false;
        }
        return this.persistenceSession.isTransient(this.pojo);
    }

    public boolean representsPersistent() {
        if (this.getSpecification().isService() || this.getSpecification().isViewModel()) {
            return true;
        }
        return this.persistenceSession.isRepresentingPersistent(this.pojo);
    }

    public boolean isDestroyed() {
        if (this.getSpecification().isService() || this.getSpecification().isViewModel()) {
            return false;
        }
        return this.persistenceSession.isDestroyed(this.pojo);
    }

    public ObjectAdapter getAggregateRoot() {
        if (!this.isParentedCollection()) {
            return this;
        }
        ParentedOid collectionOid = (ParentedOid)this.oid;
        RootOid rootOid = collectionOid.getParentOid();
        ObjectAdapter rootadapter = this.persistenceSession.adapterFor(rootOid);
        return rootadapter;
    }

    public Version getVersion() {
        if (this.isParentedCollection()) {
            return this.getAggregateRoot().getVersion();
        }
        return this.getOid().getVersion();
    }

    public void checkLock(Version otherVersion) {
        if (this.isParentedCollection()) {
            this.getAggregateRoot().checkLock(otherVersion);
            return;
        }
        Oid thisOid = this.getOid();
        Version thisVersion = thisOid.getVersion();
        if (thisVersion != null && otherVersion != null && thisVersion.different(otherVersion)) {
            if (ConcurrencyChecking.isCurrentlyEnabled()) {
                LOG.info("concurrency conflict detected on {} ({})", (Object)thisOid, (Object)otherVersion);
                String currentUser = this.authenticationSession.getUserName();
                throw new ConcurrencyException(currentUser, thisOid, thisVersion, otherVersion);
            }
            LOG.info("concurrency conflict detected but suppressed, on {} ({})", (Object)thisOid, (Object)otherVersion);
        }
    }

    public void setVersion(Version version) {
        if (this.isParentedCollection()) {
            return;
        }
        if (this.shouldSetVersion(version)) {
            RootOid rootOid = (RootOid)this.getOid();
            rootOid.setVersion(version);
        }
    }

    private boolean shouldSetVersion(Version otherVersion) {
        Version version = this.getOid().getVersion();
        return version == null || otherVersion == null || otherVersion.different(version);
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        this.toString(str);
        str.append("pojo-toString", this.pojo.toString());
        str.appendAsHex("pojo-hash", (long)this.pojo.hashCode());
        return str.toString();
    }

    protected void toString(ToString str) {
        str.append(this.aggregateResolveStateCode());
        Oid oid = this.getOid();
        if (oid != null) {
            str.append(":");
            str.append(oid.toString());
        } else {
            str.append(":-");
        }
        str.setAddComma();
        if (!this.objectSpecification.isMemoized()) {
            str.append("class", this.getPojo().getClass().getName());
        } else {
            str.append("specification", this.getSpecification().getShortIdentifier());
        }
        if (this.getOid() != null) {
            Version version = this.getOid().getVersion();
            str.append("version", version != null ? version.sequence() : null);
        }
    }

    private String aggregateResolveStateCode() {
        Oid oid = this.getOid();
        if (oid != null) {
            if (oid.isPersistent()) {
                return "P";
            }
            if (oid.isTransient()) {
                return "T";
            }
            if (oid.isViewModel()) {
                return "V";
            }
        }
        return "S";
    }
}

