/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless.logging;

import java.io.PrintStream;
import org.apache.isis.core.runtime.headless.logging.LogStream;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class LogConfig {
    private final String loggingPropertyFile;
    private final Level testLoggingLevel;
    private final PrintStream fixtureTracing;

    public LogConfig(Level testLoggingLevel, Level fixtureTracingLevel, Logger fixtureTracingLogger) {
        this(testLoggingLevel, fixtureTracingLevel, fixtureTracingLogger, null);
    }

    public LogConfig(Level testLoggingLevel, Level fixtureTracingLevel, Logger fixtureTracingLogger, String loggingPropertyFile) {
        this(testLoggingLevel, LogStream.logPrintStream(fixtureTracingLogger, fixtureTracingLevel), loggingPropertyFile);
    }

    public LogConfig(Level testLoggingLevel) {
        this(testLoggingLevel, (String)null);
    }

    public LogConfig(Level testLoggingLevel, String loggingPropertyFile) {
        this(testLoggingLevel, null, loggingPropertyFile);
    }

    public LogConfig(Level testLoggingLevel, PrintStream fixtureTracing) {
        this(testLoggingLevel, fixtureTracing, null);
    }

    public LogConfig(Level testLoggingLevel, PrintStream fixtureTracing, String loggingPropertyFile) {
        this.testLoggingLevel = testLoggingLevel != null ? testLoggingLevel : Level.INFO;
        this.fixtureTracing = fixtureTracing != null ? fixtureTracing : System.out;
        this.loggingPropertyFile = loggingPropertyFile != null ? loggingPropertyFile : "logging-integtest.properties";
    }

    public Level getTestLoggingLevel() {
        return this.testLoggingLevel;
    }

    public PrintStream getFixtureTracing() {
        return this.fixtureTracing;
    }

    public String getLoggingPropertyFile() {
        return this.loggingPropertyFile;
    }
}

