/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import java.io.PrintStream;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.PropertyResource;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.plugins.environment.IsisSystemEnvironment;
import org.apache.isis.core.runtime.headless.HeadlessAbstract;
import org.apache.isis.core.runtime.headless.HeadlessTransactionSupport;
import org.apache.isis.core.runtime.headless.IsisSystem;
import org.apache.isis.core.runtime.headless.IsisSystemBootstrapper;
import org.apache.isis.core.runtime.headless.logging.LeveledLogger;
import org.apache.isis.core.runtime.headless.logging.LogConfig;
import org.apache.isis.core.runtime.headless.logging.LogStream;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.log4j.Level;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeadlessWithBootstrappingAbstract
extends HeadlessAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(HeadlessWithBootstrappingAbstract.class);
    private final LogConfig logConfig;
    private final LeveledLogger logger;
    private static final ThreadLocal<Boolean> setupLogging = new ThreadLocal<Boolean>(){
        {
            this.set(false);
        }
    };
    private final IsisSystemBootstrapper isisSystemBootstrapper;
    private LocalDate timeBeforeTest;

    protected static PrintStream logPrintStream(org.slf4j.event.Level level) {
        return LogStream.logPrintStream(LOG, level);
    }

    protected HeadlessWithBootstrappingAbstract(Module module) {
        this(new LogConfig(org.slf4j.event.Level.INFO), module);
    }

    protected HeadlessWithBootstrappingAbstract(LogConfig logConfig, Module module) {
        boolean firstTime;
        IsisSystemEnvironment.setUnitTesting((boolean)true);
        this.logConfig = logConfig;
        this.logger = new LeveledLogger(LOG, logConfig.getTestLoggingLevel());
        boolean bl = firstTime = setupLogging.get() == false;
        if (firstTime) {
            IsisLoggingConfigurer loggingConfigurer = new IsisLoggingConfigurer(Level.INFO);
            loggingConfigurer.configureLoggingWithFile(logConfig.getLoggingPropertyFile(), new String[0]);
            setupLogging.set(true);
        }
        String integTestModuleFqcn = System.getProperty("isis.integTest.module");
        LOG.info("isis.integTest.module = {}", (Object)integTestModuleFqcn);
        String moduleFqcn = integTestModuleFqcn;
        if (moduleFqcn == null) {
            String headlessModuleFqcn = System.getProperty("isis.headless.module");
            LOG.info("isis.headless.module = {}", (Object)headlessModuleFqcn);
            moduleFqcn = headlessModuleFqcn;
        }
        Module moduleToUse = !_Strings.isNullOrEmpty((CharSequence)moduleFqcn) ? (Module)InstanceUtil.createInstance((String)moduleFqcn, Module.class, (Object[])new Object[0]) : module;
        this.isisSystemBootstrapper = IsisSystemBootstrapper.of(logConfig, IsisConfiguration.buildFromModuleTree((Module)moduleToUse, (PropertyResource[])new PropertyResource[0]));
    }

    protected void bootstrapAndSetupIfRequired() {
        System.setProperty("isis.headless", "true");
        System.setProperty("isis.integTest", "true");
        System.setProperty("isis.bddSpec", "true");
        this.isisSystemBootstrapper.bootstrapIfRequired();
        this.isisSystemBootstrapper.injectServicesInto(this);
        this.fixtureScripts.setFixtureTracing(this.logConfig.getFixtureTracing());
        this.beginTransaction();
        this.isisSystemBootstrapper.setupModuleRefData();
        this.timeBeforeTest = Clock.getTimeAsLocalDate();
    }

    private void beginTransaction() {
        IsisSystem.get().getService(HeadlessTransactionSupport.class).beginTransaction();
    }

    protected void tearDownAllModules() {
        boolean testHealthy;
        boolean bl = testHealthy = this.transactionService != null;
        if (!testHealthy) {
            return;
        }
        this.transactionService.nextTransaction(TransactionService.Policy.ALWAYS);
        this.isisSystemBootstrapper.tearDownAllModules();
        this.setFixtureClockDate(this.timeBeforeTest);
    }

    protected void log(String message) {
        this.logger.log(message);
    }
}

