/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import javax.inject.Inject;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixtures.TickingFixtureClock;
import org.apache.isis.applib.fixturescripts.BuilderScriptAbstract;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.fixturescripts.PersonaWithBuilderScript;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.sessmgmt.SessionManagementService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.joda.time.LocalDate;

public abstract class HeadlessAbstract {
    @Inject
    protected MetaModelService metaModelService;
    @Inject
    protected FixtureScripts fixtureScripts;
    @Inject
    protected FactoryService factoryService;
    @Inject
    protected ServiceRegistry serviceRegistry;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected UserService userService;
    @Inject
    protected WrapperFactory wrapperFactory;
    @Inject
    protected TransactionService transactionService;
    @Inject
    protected SessionManagementService sessionManagementService;

    protected void runFixtureScript(FixtureScript ... fixtureScriptList) {
        this.fixtureScripts.runFixtureScript(fixtureScriptList);
    }

    protected <T, F extends BuilderScriptAbstract<T, F>> T runBuilderScript(F fixtureScript) {
        return (T)this.fixtureScripts.runBuilderScript(fixtureScript);
    }

    protected <P extends PersonaWithBuilderScript<T, F>, T, F extends BuilderScriptAbstract<T, F>> T runBuilderScript(P persona) {
        return this.runBuilderScript((P)persona.builder());
    }

    protected <T> T wrap(T obj) {
        return (T)this.wrapperFactory.wrap(obj);
    }

    protected <T> T w(T obj) {
        return this.wrap(obj);
    }

    protected <T> T wrapMixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.wrapperFactory.wrapMixin(mixinClass, mixedIn);
    }

    protected <T> T wm(Class<T> mixinClass, Object mixedIn) {
        return this.wrapMixin(mixinClass, mixedIn);
    }

    protected <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.mixin(mixinClass, mixedIn);
    }

    protected <T> T m(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.m(mixinClass, mixedIn);
    }

    protected void setFixtureClockDate(LocalDate date) {
        if (date == null) {
            return;
        }
        this.setFixtureClockDate(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
    }

    protected void setFixtureClockDate(int year, int month, int day) {
        Clock instance = Clock.getInstance();
        if (instance instanceof TickingFixtureClock) {
            TickingFixtureClock.reinstateExisting();
            this.getFixtureClock().setDate(year, month, day);
            TickingFixtureClock.replaceExisting();
        }
        if (instance instanceof FixtureClock) {
            this.getFixtureClock().setDate(year, month, day);
        }
    }

    private FixtureClock getFixtureClock() {
        return (FixtureClock)FixtureClock.getInstance();
    }

    protected <T> T unwrap(T obj) {
        return (T)this.wrapperFactory.unwrap(obj);
    }
}

