/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixtures;

import java.util.List;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerAbstract;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerDelegate;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixturesInstallerFromConfiguration
extends FixturesInstallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(FixturesInstallerFromConfiguration.class);

    public FixturesInstallerFromConfiguration(IsisSessionFactory isisSessionFactory) {
        super(isisSessionFactory);
    }

    @Override
    protected void addFixturesTo(FixturesInstallerDelegate delegate) {
        List fixtureClasses = this.configuration.getAppManifest().getFixtures();
        try {
            boolean fixtureLoaded = false;
            for (Class fixtureClass : fixtureClasses) {
                LOG.info("  adding fixture {}", (Object)fixtureClass.getName());
                Object fixture = InstanceUtil.createInstance((Class)fixtureClass, (Object[])new Object[0]);
                fixtureLoaded = true;
                delegate.addFixture(fixture);
            }
            if (!fixtureLoaded) {
                LOG.debug("No fixtures loaded from configuration");
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new IsisException((Throwable)e);
        }
    }
}

