/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog.jdo;

import javax.annotation.PostConstruct;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.applib.services.exceprecog.jdo.ExceptionRecognizerForJDODataStoreException;
import org.apache.isis.applib.services.exceprecog.jdo.ExceptionRecognizerForJDODataStoreExceptionIntegrityConstraintViolationForeignKeyNoActionException;
import org.apache.isis.applib.services.exceprecog.jdo.ExceptionRecognizerForJDOObjectNotFoundException;
import org.apache.isis.applib.services.exceprecog.jdo.ExceptionRecognizerForSQLIntegrityConstraintViolationUniqueOrIndexException;
import org.apache.isis.config.internal._Config;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ExceptionRecognizerCompositeForJdoObjectStore
extends ExceptionRecognizerComposite {
    public static final String KEY_DISABLE = "isis.services.ExceptionRecognizerCompositeForJdoObjectStore.disable";

    public ExceptionRecognizerCompositeForJdoObjectStore() {
        super(new ExceptionRecognizer[0]);
    }

    @Programmatic
    @PostConstruct
    public void init() {
        boolean disabled = _Config.getConfiguration().getBoolean(KEY_DISABLE, false);
        if (disabled) {
            return;
        }
        this.addChildren();
        super.init();
    }

    protected void addChildren() {
        this.add((ExceptionRecognizer)new ExceptionRecognizerForSQLIntegrityConstraintViolationUniqueOrIndexException());
        this.add((ExceptionRecognizer)new ExceptionRecognizerForJDODataStoreExceptionIntegrityConstraintViolationForeignKeyNoActionException());
        this.add((ExceptionRecognizer)new ExceptionRecognizerForJDOObjectNotFoundException());
        this.add((ExceptionRecognizer)new ExceptionRecognizerForJDODataStoreException());
    }
}

