/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport_v3_2;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession5;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessor;
import org.datanucleus.enhancement.Persistable;

public abstract class PersistenceQueryProcessorAbstract<T extends PersistenceQuery>
implements PersistenceQueryProcessor<T> {
    final PersistenceSession5 persistenceSession;

    protected PersistenceQueryProcessorAbstract(PersistenceSession5 persistenceSession) {
        this.persistenceSession = persistenceSession;
    }

    protected List<ObjectAdapter> loadAdapters(List<?> pojos) {
        ArrayList adapters = _Lists.newArrayList();
        for (Object pojo : pojos) {
            ObjectAdapter adapter;
            if (pojo instanceof Persistable) {
                adapter = this.persistenceSession.initializeMapAndCheckConcurrency((Persistable)pojo);
                Assert.assertNotNull((Object)adapter);
            } else {
                adapter = this.persistenceSession.adapterFor(pojo);
                Assert.assertNotNull((Object)adapter);
            }
            adapters.add(adapter);
        }
        return adapters;
    }

    protected static IsisJdoSupport_v3_2 isisJdoSupport() {
        return (IsisJdoSupport_v3_2)IsisContext.getServicesInjector().lookupServiceElseFail(IsisJdoSupport_v3_2.class);
    }
}

