/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.Query;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport_v3_2;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession5;
import org.apache.isis.objectstore.jdo.datanucleus.metamodel.JdoPropertyUtils;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceQueryFindUsingApplibQueryProcessor
extends PersistenceQueryProcessorAbstract<PersistenceQueryFindUsingApplibQueryDefault> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceQueryFindUsingApplibQueryProcessor.class);

    public PersistenceQueryFindUsingApplibQueryProcessor(PersistenceSession5 persistenceSession) {
        super(persistenceSession);
    }

    public List<ObjectAdapter> process(PersistenceQueryFindUsingApplibQueryDefault persistenceQuery) {
        String queryName = persistenceQuery.getQueryName();
        ObjectSpecification objectSpec = persistenceQuery.getSpecification();
        List<?> results = (objectSpec.getFullIdentifier() + "#pk").equals(queryName) ? this.getResultsPk(persistenceQuery) : this.getResults(persistenceQuery);
        return this.loadAdapters(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> getResultsPk(PersistenceQueryFindUsingApplibQueryDefault persistenceQuery) {
        IsisJdoSupport_v3_2 isisJdoSupport = PersistenceQueryFindUsingApplibQueryProcessor.isisJdoSupport();
        String queryName = persistenceQuery.getQueryName();
        Map<String, Object> map = PersistenceQueryFindUsingApplibQueryProcessor.unwrap(persistenceQuery.getArgumentsAdaptersByParameterName());
        ObjectSpecification objectSpec = persistenceQuery.getSpecification();
        Class cls = objectSpec.getCorrespondingClass();
        if (!JdoPropertyUtils.hasPrimaryKeyProperty((ObjectSpecification)objectSpec)) {
            throw new UnsupportedOperationException("cannot search by primary key for DataStore-assigned entities");
        }
        OneToOneAssociation pkOtoa = JdoPropertyUtils.getPrimaryKeyPropertyFor((ObjectSpecification)objectSpec);
        String pkOtoaId = pkOtoa.getId();
        String filter = pkOtoaId + "==" + map.get(pkOtoaId);
        Query jdoQuery = this.persistenceSession.newJdoQuery(cls, filter);
        isisJdoSupport.disableMultivaluedFetch(jdoQuery);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} # {} ( {} )", new Object[]{cls.getName(), queryName, filter});
        }
        try {
            List results = (List)jdoQuery.execute();
            ArrayList arrayList = _Lists.newArrayList((Collection)results);
            return arrayList;
        }
        finally {
            jdoQuery.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> getResults(PersistenceQueryFindUsingApplibQueryDefault persistenceQuery) {
        IsisJdoSupport_v3_2 isisJdoSupport = PersistenceQueryFindUsingApplibQueryProcessor.isisJdoSupport();
        String queryName = persistenceQuery.getQueryName();
        Map<String, Object> argumentsByParameterName = PersistenceQueryFindUsingApplibQueryProcessor.unwrap(persistenceQuery.getArgumentsAdaptersByParameterName());
        QueryCardinality cardinality = persistenceQuery.getCardinality();
        ObjectSpecification objectSpec = persistenceQuery.getSpecification();
        Class cls = objectSpec.getCorrespondingClass();
        Query jdoQuery = this.persistenceSession.newJdoNamedQuery(cls, queryName);
        isisJdoSupport.disableMultivaluedFetch(jdoQuery);
        if (persistenceQuery.hasRange()) {
            jdoQuery.setRange(persistenceQuery.getStart(), persistenceQuery.getEnd());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} # {} ( {} )", new Object[]{cls.getName(), queryName, argumentsByParameterName});
        }
        try {
            List<?> results = (List<?>)jdoQuery.executeWithMap(argumentsByParameterName);
            if (results == null) {
                List list = Collections.emptyList();
                return list;
            }
            List<?> resultsToReturn = cardinality == QueryCardinality.MULTIPLE ? results : this.firstIfAnyOf(results);
            ArrayList arrayList = _Lists.newArrayList(resultsToReturn);
            return arrayList;
        }
        finally {
            jdoQuery.closeAll();
        }
    }

    private List<?> firstIfAnyOf(List<?> results) {
        return results.isEmpty() ? Collections.emptyList() : results.subList(0, 1);
    }

    private static Map<String, Object> unwrap(Map<String, ObjectAdapter> argumentAdaptersByParameterName) {
        HashMap argumentsByParameterName = _Maps.newHashMap();
        for (String parameterName : argumentAdaptersByParameterName.keySet()) {
            ObjectAdapter argumentAdapter = argumentAdaptersByParameterName.get(parameterName);
            Object argument = ObjectAdapter.Util.unwrapPojo((ManagedObject)argumentAdapter);
            argumentsByParameterName.put(parameterName, argument);
        }
        return argumentsByParameterName;
    }
}

