/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.sql.Timestamp;
import javax.jdo.listener.InstanceLifecycleEvent;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.datanucleus.enhancement.Persistable;

public class Utils {
    private static Object jdoObjectIdFor(InstanceLifecycleEvent event) {
        Persistable persistenceCapable = Utils.persistenceCapableFor(event);
        Object jdoObjectId = persistenceCapable.dnGetObjectId();
        return jdoObjectId;
    }

    static Persistable persistenceCapableFor(InstanceLifecycleEvent event) {
        return (Persistable)event.getSource();
    }

    static Version getVersionIfAny(Persistable pojo, AuthenticationSession authenticationSession) {
        Object jdoVersion = pojo.dnGetVersion();
        if (jdoVersion instanceof Long) {
            Long longVersion = (Long)jdoVersion;
            return Version.Factory.ifPresent((Long)longVersion, (String)authenticationSession.getUserName());
        }
        if (jdoVersion instanceof Timestamp) {
            Timestamp timestampVersion = (Timestamp)jdoVersion;
            return Version.of((long)timestampVersion.getTime(), (String)authenticationSession.getUserName());
        }
        return null;
    }
}

