/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jdo.PersistenceManagerFactory;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.system.persistence.DataNucleusApplicationComponents5;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession5;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.objectstore.jdo.datanucleus.JDOStateManagerForIsis;
import org.apache.isis.objectstore.jdo.service.RegisterEntities;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSessionFactory5
implements PersistenceSessionFactory,
ApplicationScopedComponent,
FixturesInstalledFlag {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceSessionFactory5.class);
    public static final String JDO_OBJECTSTORE_CONFIG_PREFIX = "isis.persistor.datanucleus";
    public static final String DATANUCLEUS_CONFIG_PREFIX = "isis.persistor.datanucleus.impl";
    private final _Lazy<DataNucleusApplicationComponents5> applicationComponents = _Lazy.threadSafe(this::createDataNucleusApplicationComponents);
    private IsisConfiguration configuration;
    private Boolean fixturesInstalled;

    @Programmatic
    public void init() {
        this.configuration = _Config.getConfiguration();
        this.createDataNucleusApplicationComponents();
    }

    @Programmatic
    public boolean isInitialized() {
        return this.configuration != null;
    }

    private DataNucleusApplicationComponents5 createDataNucleusApplicationComponents() {
        RegisterEntities registerEntities = new RegisterEntities();
        Set classesToBePersisted = registerEntities.getEntityTypes();
        IsisConfiguration jdoObjectstoreConfig = this.configuration.createSubset(JDO_OBJECTSTORE_CONFIG_PREFIX);
        IsisConfiguration dataNucleusConfig = this.configuration.createSubset(DATANUCLEUS_CONFIG_PREFIX);
        Map datanucleusProps = dataNucleusConfig.asMap();
        PersistenceSessionFactory5.addDataNucleusPropertiesIfRequired(datanucleusProps);
        return new DataNucleusApplicationComponents5(jdoObjectstoreConfig, datanucleusProps, classesToBePersisted);
    }

    @Programmatic
    public void catalogNamedQueries(SpecificationLoader specificationLoader) {
        RegisterEntities registerEntities = new RegisterEntities();
        Set classesToBePersisted = registerEntities.getEntityTypes();
        DataNucleusApplicationComponents5.catalogNamedQueries(classesToBePersisted, specificationLoader);
    }

    private boolean shouldCreate(DataNucleusApplicationComponents5 applicationComponents) {
        return applicationComponents == null || applicationComponents.isStale();
    }

    private static void addDataNucleusPropertiesIfRequired(Map<String, String> props) {
        PersistenceSessionFactory5.putIfNotPresent(props, "datanucleus.objectProvider.className", JDOStateManagerForIsis.class.getName());
        PersistenceSessionFactory5.putIfNotPresent(props, "javax.jdo.PersistenceManagerFactoryClass", JDOPersistenceManagerFactory.class.getName());
        PersistenceSessionFactory5.putIfNotPresent(props, "datanucleus.schema.autoCreateDatabase", Boolean.FALSE.toString());
        PersistenceSessionFactory5.putIfNotPresent(props, "datanucleus.schema.validateAll", Boolean.TRUE.toString());
        PersistenceSessionFactory5.putIfNotPresent(props, "datanucleus.cache.level2.type", "none");
        PersistenceSessionFactory5.putIfNotPresent(props, "datanucleus.persistenceUnitLoadClasses", Boolean.TRUE.toString());
        String connectionFactoryName = props.get("datanucleus.ConnectionFactoryName");
        if (connectionFactoryName != null) {
            String connectionFactory2Name = props.get("datanucleus.ConnectionFactory2Name");
            String transactionType = props.get("javax.jdo.option.TransactionType");
            if (transactionType == null) {
                LOG.info("found config properties to use non-JTA JNDI datasource ({})", (Object)connectionFactoryName);
                if (connectionFactory2Name != null) {
                    LOG.warn("found config properties to use non-JTA JNDI datasource ({}); second '-nontx' JNDI datasource also configured but will not be used ({})", (Object)connectionFactoryName, (Object)connectionFactory2Name);
                }
            } else {
                LOG.info("found config properties to use JTA JNDI datasource ({})", (Object)connectionFactoryName);
            }
            if (connectionFactory2Name == null) {
                LOG.error("found config properties to use JTA JNDI datasource ({}) but config properties for second '-nontx' JNDI datasource were *not* found", (Object)connectionFactoryName);
            } else {
                LOG.info("... and config properties for second '-nontx' JNDI datasource also found; {}", (Object)connectionFactory2Name);
            }
            return;
        }
        LOG.info("did *not* find config properties to use JNDI datasource; will use JDBC");
        PersistenceSessionFactory5.putIfNotPresent(props, "javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
        PersistenceSessionFactory5.putIfNotPresent(props, "javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test");
        PersistenceSessionFactory5.putIfNotPresent(props, "javax.jdo.option.ConnectionUserName", "sa");
        PersistenceSessionFactory5.putIfNotPresent(props, "javax.jdo.option.ConnectionPassword", "");
    }

    private static void putIfNotPresent(Map<String, String> props, String key, String value) {
        if (!props.containsKey(key)) {
            props.put(key, value);
        }
    }

    @Programmatic
    public final void shutdown() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.applicationComponents.isMemoized()) {
            ((DataNucleusApplicationComponents5)this.applicationComponents.get()).shutdown();
            this.applicationComponents.clear();
        }
        this.configuration = null;
    }

    @Programmatic
    public PersistenceSession5 createPersistenceSession(ServicesInjector servicesInjector, AuthenticationSession authenticationSession) {
        Objects.requireNonNull(this.applicationComponents.get(), () -> "PersistenceSession5 requires initialization. " + this.hashCode());
        PersistenceSessionFactory5 fixturesInstalledFlag = this;
        this.guardAgainstStaleState();
        PersistenceManagerFactory persistenceManagerFactory = ((DataNucleusApplicationComponents5)this.applicationComponents.get()).getPersistenceManagerFactory();
        return new PersistenceSession5(servicesInjector, authenticationSession, persistenceManagerFactory, fixturesInstalledFlag);
    }

    @Programmatic
    public Boolean isFixturesInstalled() {
        return this.fixturesInstalled;
    }

    @Programmatic
    public void setFixturesInstalled(Boolean fixturesInstalled) {
        this.fixturesInstalled = fixturesInstalled;
    }

    private void guardAgainstStaleState() {
        if (((DataNucleusApplicationComponents5)this.applicationComponents.get()).isStale()) {
            try {
                ((DataNucleusApplicationComponents5)this.applicationComponents.get()).shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.applicationComponents.clear();
        }
    }
}

