/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.jdo.FetchPlan;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.listener.InstanceLifecycleListener;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterByIdProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingLifecycleEventFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedLifecycleEventFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.FreeStandingList;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.persistence.NotPersistableException;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.PojoRefreshException;
import org.apache.isis.core.runtime.persistence.UnsupportedFindException;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.apache.isis.core.runtime.system.persistence.IsisLifecycleListener;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionBase;
import org.apache.isis.core.runtime.system.persistence.Utils;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.commands.DataNucleusCreateObjectCommand;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.commands.DataNucleusDeleteObjectCommand;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindAllInstancesProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryFindUsingApplibQueryProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessor;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.spi.JdoObjectIdSerializer;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.DatastoreIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSession5
extends PersistenceSessionBase
implements IsisLifecycleListener.PersistenceSessionLifecycleManagement {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceSession5.class);
    private ObjectAdapterContext objectAdapterContext;

    public PersistenceSession5(ServicesInjector servicesInjector, AuthenticationSession authenticationSession, PersistenceManagerFactory jdoPersistenceManagerFactory, FixturesInstalledFlag fixturesInstalledFlag) {
        super(servicesInjector, authenticationSession, jdoPersistenceManagerFactory, fixturesInstalledFlag);
    }

    public void open() {
        this.ensureNotOpened();
        this.openedAtSystemNanos = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("opening {}", (Object)this);
        }
        this.persistenceManager = this.jdoPersistenceManagerFactory.getPersistenceManager();
        PersistenceSession5 psLifecycleMgmt = this;
        IsisLifecycleListener isisLifecycleListener = new IsisLifecycleListener(psLifecycleMgmt);
        this.persistenceManager.addInstanceLifecycleListener((InstanceLifecycleListener)isisLifecycleListener, (Class[])null);
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindAllInstances.class, new PersistenceQueryFindAllInstancesProcessor(this));
        this.persistenceQueryProcessorByClass.put(PersistenceQueryFindUsingApplibQueryDefault.class, new PersistenceQueryFindUsingApplibQueryProcessor(this));
        this.objectAdapterContext = ObjectAdapterContext.openContext((ServicesInjector)this.servicesInjector, (AuthenticationSession)this.authenticationSession, (SpecificationLoader)this.specificationLoader, (PersistenceSession)this);
        this.startRequestOnRequestScopedServices();
        this.postConstructOnRequestScopedServices();
        if (this.metricsService instanceof InstanceLifecycleListener) {
            InstanceLifecycleListener metricsService = (InstanceLifecycleListener)this.metricsService;
            this.persistenceManager.addInstanceLifecycleListener(metricsService, (Class[])null);
        }
        Command command = this.createCommand();
        Interaction interaction = (Interaction)this.factoryService.instantiate(Interaction.class);
        Timestamp timestamp = this.clockService.nowAsJavaSqlTimestamp();
        String userName = this.userService.getUser().getName();
        command.internal().setTimestamp(timestamp);
        command.internal().setUser(userName);
        interaction.setUniqueId(command.getUniqueId());
        this.commandContext.setCommand(command);
        this.interactionContext.setInteraction(interaction);
        this.state = PersistenceSessionBase.State.OPEN;
    }

    private void postConstructOnRequestScopedServices() {
        this.servicesInjector.streamServices().forEach(service -> {
            if (service instanceof RequestScopedService) {
                ((RequestScopedService)service).__isis_postConstruct();
            }
        });
    }

    private void startRequestOnRequestScopedServices() {
        this.servicesInjector.streamServices().forEach(service -> {
            if (service instanceof RequestScopedService) {
                ((RequestScopedService)service).__isis_startRequest(this.servicesInjector);
            }
        });
    }

    private Command createCommand() {
        Command command = this.commandService.create();
        this.servicesInjector.injectServicesInto((Object)command);
        return command;
    }

    public void close() {
        if (this.state == PersistenceSessionBase.State.CLOSED) {
            return;
        }
        this.completeCommandFromInteractionAndClearDomainEvents();
        this.transactionManager.flushTransaction();
        try {
            IsisTransaction currentTransaction = this.transactionManager.getCurrentTransaction();
            if (currentTransaction != null && !currentTransaction.getState().isComplete()) {
                if (currentTransaction.getState().canCommit()) {
                    this.transactionManager.endTransaction();
                } else if (currentTransaction.getState().canAbort()) {
                    this.transactionManager.abortTransaction();
                }
            }
        }
        catch (Throwable ex) {
            LOG.error("close: failed to end transaction; continuing to avoid memory leakage");
        }
        this.preDestroyOnRequestScopedServices();
        this.endRequestOnRequestScopeServices();
        try {
            this.persistenceManager.close();
        }
        catch (Throwable ex) {
            LOG.error("close: failed to close JDO persistenceManager; continuing to avoid memory leakage");
        }
        this.objectAdapterContext.close();
        this.state = PersistenceSessionBase.State.CLOSED;
    }

    private void endRequestOnRequestScopeServices() {
        this.servicesInjector.streamServices().forEach(service -> {
            if (service instanceof RequestScopedService) {
                ((RequestScopedService)service).__isis_endRequest();
            }
        });
    }

    private void preDestroyOnRequestScopedServices() {
        this.servicesInjector.streamServices().forEach(service -> {
            if (service instanceof RequestScopedService) {
                ((RequestScopedService)service).__isis_preDestroy();
            }
        });
    }

    private void completeCommandFromInteractionAndClearDomainEvents() {
        Command command = this.commandContext.getCommand();
        Interaction interaction = this.interactionContext.getInteraction();
        if (command.getStartedAt() != null && command.getCompletedAt() == null) {
            Interaction.Execution priorExecution = interaction.getPriorExecution();
            Timestamp completedAt = priorExecution != null ? priorExecution.getCompletedAt() : this.clockService.nowAsJavaSqlTimestamp();
            command.internal().setCompletedAt(completedAt);
        }
        if (command.getMemberIdentifier() != null && this.metricsService.numberObjectsDirtied() > 0) {
            command.internal().setPersistHint(true);
        }
        this.commandService.complete(command);
        interaction.clear();
    }

    public <T> List<ObjectAdapter> allMatchingQuery(Query<T> query) {
        ObjectAdapter instances = this.findInstancesInTransaction(query, QueryCardinality.MULTIPLE);
        return CollectionFacet.Utils.toAdapterList((ManagedObject)instances);
    }

    public <T> ObjectAdapter firstMatchingQuery(Query<T> query) {
        ObjectAdapter instances = this.findInstancesInTransaction(query, QueryCardinality.SINGLE);
        List list = CollectionFacet.Utils.toAdapterList((ManagedObject)instances);
        return list.size() > 0 ? (ObjectAdapter)list.get(0) : null;
    }

    private <T> ObjectAdapter findInstancesInTransaction(Query<T> query, QueryCardinality cardinality) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("findInstances using (applib) Query: {}", query);
        }
        PersistenceQuery persistenceQuery = this.createPersistenceQueryFor(query, cardinality);
        if (LOG.isDebugEnabled()) {
            LOG.debug("maps to (core runtime) PersistenceQuery: {}", (Object)persistenceQuery);
        }
        PersistenceQueryProcessor<? extends PersistenceQuery> processor = this.lookupProcessorFor(persistenceQuery);
        List instances = (List)this.transactionManager.executeWithinTransaction(() -> this.processPersistenceQuery(processor, persistenceQuery));
        ObjectSpecification specification = persistenceQuery.getSpecification();
        FreeStandingList results = FreeStandingList.of((ObjectSpecification)specification, (List)instances);
        return this.adapterFor(results);
    }

    private final PersistenceQuery createPersistenceQueryFor(Query<?> query, QueryCardinality cardinality) {
        PersistenceQuery persistenceQuery = this.persistenceQueryFactory.createPersistenceQueryFor(query, cardinality);
        if (persistenceQuery == null) {
            throw new IllegalArgumentException("Unknown Query type: " + query.getDescription());
        }
        return persistenceQuery;
    }

    private PersistenceQueryProcessor<? extends PersistenceQuery> lookupProcessorFor(PersistenceQuery persistenceQuery) {
        Class<?> persistenceQueryClass = persistenceQuery.getClass();
        PersistenceQueryProcessor processor = (PersistenceQueryProcessor)this.persistenceQueryProcessorByClass.get(persistenceQueryClass);
        if (processor == null) {
            throw new UnsupportedFindException(MessageFormat.format("Unsupported PersistenceQuery class: {0}", persistenceQueryClass.getName()));
        }
        return processor;
    }

    private <Q extends PersistenceQuery> List<ObjectAdapter> processPersistenceQuery(PersistenceQueryProcessor<Q> persistenceQueryProcessor, PersistenceQuery persistenceQuery) {
        return persistenceQueryProcessor.process(persistenceQuery);
    }

    public boolean isFixturesInstalled() {
        if (this.fixturesInstalledFlag.isFixturesInstalled() == null) {
            this.fixturesInstalledFlag.setFixturesInstalled(Boolean.valueOf(this.objectStoreIsFixturesInstalled()));
        }
        return this.fixturesInstalledFlag.isFixturesInstalled();
    }

    private boolean objectStoreIsFixturesInstalled() {
        boolean installFixtures = this.configuration.getBoolean("isis.persistor.datanucleus.install-fixtures", false);
        LOG.info("isFixturesInstalled: {} = {}", (Object)"isis.persistor.datanucleus.install-fixtures", (Object)installFixtures);
        return !installFixtures;
    }

    public Object fetchPersistentPojo(RootOid rootOid) {
        Object result;
        Objects.requireNonNull(rootOid);
        LOG.debug("getObject; oid={}", (Object)rootOid);
        try {
            Class<?> cls = this.clsOf(rootOid);
            Object jdoObjectId = JdoObjectIdSerializer.toJdoObjectId(rootOid);
            FetchPlan fetchPlan = this.persistenceManager.getFetchPlan();
            fetchPlan.addGroup("default");
            result = this.persistenceManager.getObjectById(cls, jdoObjectId);
        }
        catch (RuntimeException e) {
            Class<ExceptionRecognizer> serviceClass = ExceptionRecognizer.class;
            List exceptionRecognizers = this.lookupServices(serviceClass);
            for (ExceptionRecognizer exceptionRecognizer : exceptionRecognizers) {
                ExceptionRecognizer.Recognition recognition = exceptionRecognizer.recognize2((Throwable)e);
                if (recognition == null || recognition.getCategory() != ExceptionRecognizer.Category.NOT_FOUND) continue;
                throw new ObjectNotFoundException((Oid)rootOid, (Throwable)e);
            }
            throw e;
        }
        if (result == null) {
            throw new ObjectNotFoundException((Oid)rootOid);
        }
        return result;
    }

    public Map<RootOid, Object> fetchPersistentPojos(List<RootOid> rootOids) {
        if (rootOids.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Object> dnOids = new ArrayList<Object>(rootOids.size());
        for (RootOid rootOid : rootOids) {
            DatastoreIdImpl datastoreId;
            Object id = JdoObjectIdSerializer.toJdoObjectId(rootOid);
            if (id instanceof SingleFieldIdentity) {
                dnOids.add(id);
                continue;
            }
            if (id instanceof String && ((String)id).contains("[OID]")) {
                datastoreId = new DatastoreIdImpl((String)id);
                dnOids.add(datastoreId);
                continue;
            }
            datastoreId = new DatastoreIdImpl(this.clsOf(rootOid).getName(), id);
            dnOids.add(datastoreId);
        }
        FetchPlan fetchPlan = this.persistenceManager.getFetchPlan();
        fetchPlan.addGroup("default");
        ArrayList<Object> persistentPojos = new ArrayList<Object>(rootOids.size());
        try {
            Collection pojos = (Collection)_Casts.uncheckedCast((Object)this.persistenceManager.getObjectsById(dnOids, true));
            for (Object e : pojos) {
                try {
                    persistentPojos.add(e);
                }
                catch (Exception ex) {
                    persistentPojos.add(null);
                }
            }
        }
        catch (NucleusObjectNotFoundException nonfe) {
            for (Object e : dnOids) {
                try {
                    Object persistentPojo = this.persistenceManager.getObjectById(e);
                    persistentPojos.add(persistentPojo);
                }
                catch (Exception ex) {
                    persistentPojos.add(null);
                }
            }
        }
        Map<RootOid, Object> pojoByOid = PersistenceSession5.zip(rootOids, persistentPojos);
        return pojoByOid;
    }

    private static Map<RootOid, Object> zip(List<RootOid> rootOids, Collection<Object> pojos) {
        LinkedHashMap pojoByOid = _Maps.newLinkedHashMap();
        int i = 0;
        for (Object pojo : pojos) {
            RootOid rootOid = rootOids.get(i++);
            pojoByOid.put(rootOid, pojo);
        }
        return pojoByOid;
    }

    private Class<?> clsOf(RootOid oid) {
        ObjectSpecification objectSpec = this.getSpecificationLoader().lookupBySpecId(oid.getObjectSpecId());
        return objectSpec.getCorrespondingClass();
    }

    public void refreshRoot(Object domainObject) {
        if (!this.isRepresentingPersistent(domainObject)) {
            this.debugLogNotPersistentIgnoring(domainObject);
            return;
        }
        this.debugLogRefreshImmediately(domainObject);
        try {
            this.persistenceManager.refresh(domainObject);
        }
        catch (RuntimeException e) {
            Oid oid = this.oidFor(domainObject);
            throw new PojoRefreshException(oid, (Throwable)e);
        }
        this.initializeMapAndCheckConcurrency((Persistable)domainObject);
    }

    public void makePersistentInTransaction(ObjectAdapter adapter) {
        if (adapter.representsPersistent()) {
            throw new NotPersistableException("Object already persistent: " + adapter);
        }
        ObjectSpecification specification = adapter.getSpecification();
        if (specification.isService()) {
            throw new NotPersistableException("Cannot persist services: " + adapter);
        }
        this.getTransactionManager().executeWithinTransaction(() -> this.makePersistentTransactionAssumed(adapter));
    }

    private void makePersistentTransactionAssumed(ObjectAdapter adapter) {
        if (PersistenceSession5.alreadyPersistedOrNotPersistable(adapter)) {
            return;
        }
        LOG.debug("persist {}", (Object)adapter);
        if (PersistenceSession5.alreadyPersistedOrNotPersistable(adapter)) {
            return;
        }
        this.addCreateObjectCommand(adapter);
    }

    private void addCreateObjectCommand(ObjectAdapter object) {
        CreateObjectCommand createObjectCommand = this.newCreateObjectCommand(object);
        this.transactionManager.addCommand((PersistenceCommand)createObjectCommand);
    }

    private static boolean alreadyPersistedOrNotPersistable(ObjectAdapter adapter) {
        return adapter.representsPersistent() || PersistenceSession5.objectSpecNotPersistable(adapter);
    }

    private static boolean objectSpecNotPersistable(ObjectAdapter adapter) {
        return adapter.isParentedCollection();
    }

    public void destroyObjectInTransaction(ObjectAdapter adapter) {
        ObjectSpecification spec = adapter.getSpecification();
        if (spec.isParented()) {
            return;
        }
        LOG.debug("destroyObject {}", (Object)adapter);
        this.transactionManager.executeWithinTransaction(() -> {
            DestroyObjectCommand command = this.newDestroyObjectCommand(adapter);
            this.transactionManager.addCommand((PersistenceCommand)command);
        });
    }

    private CreateObjectCommand newCreateObjectCommand(ObjectAdapter adapter) {
        this.ensureOpened();
        LOG.debug("create object - creating command for: {}", (Object)adapter);
        if (adapter.representsPersistent()) {
            throw new IllegalArgumentException("Adapter is persistent; adapter: " + adapter);
        }
        return new DataNucleusCreateObjectCommand(adapter, this.persistenceManager);
    }

    private DestroyObjectCommand newDestroyObjectCommand(ObjectAdapter adapter) {
        this.ensureOpened();
        LOG.debug("destroy object - creating command for: {}", (Object)adapter);
        if (!adapter.representsPersistent()) {
            throw new IllegalArgumentException("Adapter is not persistent; adapter: " + adapter);
        }
        return new DataNucleusDeleteObjectCommand(adapter, this.persistenceManager);
    }

    public void execute(List<PersistenceCommand> commands) {
        this.executeCommands(commands);
    }

    private void executeCommands(List<PersistenceCommand> commands) {
        for (PersistenceCommand command : commands) {
            command.execute(null);
        }
        this.persistenceManager.flush();
    }

    @Override
    public void enlistDeletingAndInvokeIsisRemovingCallbackFacet(Persistable pojo) {
        ObjectAdapter adapter = this.adapterFor(pojo);
        this.changedObjectsServiceInternal.enlistDeleting(adapter);
        CallbackFacet.Util.callCallback((ManagedObject)adapter, RemovingCallbackFacet.class);
        this.objectAdapterContext.postLifecycleEventIfRequired((ManagedObject)adapter, RemovingLifecycleEventFacet.class);
    }

    @Override
    public ObjectAdapter initializeMapAndCheckConcurrency(Persistable pojo) {
        Persistable pc = pojo;
        this.servicesInjector.injectInto((Object)pojo);
        Version datastoreVersion = this.getVersionIfAny(pc);
        RootOid originalOid = this.objectAdapterContext.createPersistentOrViewModelOid((Object)pojo);
        ObjectAdapter adapter = this.objectAdapterContext.recreatePojo((Oid)originalOid, (Object)pojo);
        adapter.setVersion(datastoreVersion);
        CallbackFacet.Util.callCallback((ManagedObject)adapter, LoadedCallbackFacet.class);
        this.objectAdapterContext.postLifecycleEventIfRequired((ManagedObject)adapter, LoadedLifecycleEventFacet.class);
        return adapter;
    }

    public String identifierFor(Object pojo) {
        Object jdoOid = this.pm().getObjectId(pojo);
        Objects.requireNonNull(jdoOid, () -> String.format("Pojo of type '%s' is not recognized by JDO.", pojo.getClass().getName()));
        return JdoObjectIdSerializer.toOidIdentifier(jdoOid);
    }

    @Override
    public void invokeIsisPersistingCallback(Persistable pojo) {
        if (this.isTransient(pojo)) {
            ManagedObject adapter = ManagedObject.of(() -> this.getSpecificationLoader().loadSpecification(pojo.getClass()), (Object)pojo);
            CallbackFacet.Util.callCallback((ManagedObject)adapter, PersistingCallbackFacet.class);
            this.objectAdapterContext.postLifecycleEventIfRequired(adapter, PersistingLifecycleEventFacet.class);
        }
    }

    @Override
    public void enlistCreatedAndRemapIfRequiredThenInvokeIsisInvokePersistingOrUpdatedCallback(Persistable pojo) {
        ObjectAdapter adapter = this.adapterFor(pojo);
        RootOid rootOid = (RootOid)adapter.getOid();
        if (rootOid.isTransient()) {
            this.objectAdapterContext.asPersistent(adapter, (PersistenceSession)this);
            CallbackFacet.Util.callCallback((ManagedObject)adapter, PersistedCallbackFacet.class);
            this.objectAdapterContext.postLifecycleEventIfRequired((ManagedObject)adapter, PersistedLifecycleEventFacet.class);
            this.changedObjectsServiceInternal.enlistCreated(adapter);
        } else {
            CallbackFacet.Util.callCallback((ManagedObject)adapter, UpdatedCallbackFacet.class);
            this.objectAdapterContext.postLifecycleEventIfRequired((ManagedObject)adapter, UpdatedLifecycleEventFacet.class);
        }
        Version versionIfAny = this.getVersionIfAny(pojo);
        adapter.setVersion(versionIfAny);
    }

    @Override
    public void enlistUpdatingAndInvokeIsisUpdatingCallback(Persistable pojo) {
        ObjectAdapter adapter = this.objectAdapterContext.fetchPersistent((Object)pojo);
        if (adapter == null) {
            throw new RuntimeException("DN could not find objectId for pojo (unexpected) and so could not map into Isis; pojo=[" + pojo + "]");
        }
    }

    @Override
    public void ensureRootObject(Persistable pojo) {
        Oid oid = this.adapterFor(pojo).getOid();
        if (!(oid instanceof RootOid)) {
            throw new IsisException(MessageFormat.format("Not a RootOid: oid={0}, for {1}", oid, pojo));
        }
    }

    private Version getVersionIfAny(Persistable pojo) {
        return Utils.getVersionIfAny(pojo, this.authenticationSession);
    }

    public boolean isTransient(@Nullable Object pojo) {
        if (pojo != null && pojo instanceof Persistable) {
            Persistable p = (Persistable)pojo;
            boolean isPersistent = p.dnIsPersistent();
            boolean isDeleted = p.dnIsDeleted();
            if (!isPersistent && !isDeleted) {
                return true;
            }
        }
        return false;
    }

    public boolean isRepresentingPersistent(@Nullable Object pojo) {
        if (pojo instanceof Persistable) {
            Persistable p = (Persistable)pojo;
            return p.dnIsPersistent();
        }
        return false;
    }

    public boolean isDestroyed(@Nullable Object pojo) {
        if (pojo instanceof Persistable) {
            Persistable p = (Persistable)pojo;
            return p.dnIsDeleted();
        }
        return false;
    }

    public boolean isRecognized(Object pojo) {
        Object jdoOid;
        return pojo != null && pojo instanceof Persistable && (jdoOid = this.pm().getObjectId(pojo)) != null;
    }

    public ObjectAdapterContext.MementoRecreateObjectSupport mementoSupport() {
        return this.objectAdapterContext.mementoSupport();
    }

    public ObjectAdapterProvider getObjectAdapterProvider() {
        return this.objectAdapterContext.getObjectAdapterProvider();
    }

    public ObjectAdapterByIdProvider getObjectAdapterByIdProvider() {
        return this.objectAdapterContext.getObjectAdapterByIdProvider();
    }

    private void debugLogNotPersistentIgnoring(Object domainObject) {
        if (LOG.isDebugEnabled() && domainObject != null) {
            Oid oid = this.oidFor(domainObject);
            LOG.debug("; oid={} not persistent - ignoring", (Object)oid.enString());
        }
    }

    private void debugLogRefreshImmediately(Object domainObject) {
        if (LOG.isDebugEnabled()) {
            Oid oid = this.oidFor(domainObject);
            LOG.debug("refresh immediately; oid={}", (Object)oid.enString());
        }
    }
}

