/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.Map;
import javax.jdo.listener.AttachLifecycleListener;
import javax.jdo.listener.ClearLifecycleListener;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.DetachLifecycleListener;
import javax.jdo.listener.DirtyLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.LoadLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.system.persistence.SuspendableListener;
import org.apache.isis.core.runtime.system.persistence.Utils;
import org.datanucleus.enhancement.Persistable;

public class IsisLifecycleListener
implements AttachLifecycleListener,
ClearLifecycleListener,
CreateLifecycleListener,
DeleteLifecycleListener,
DetachLifecycleListener,
DirtyLifecycleListener,
LoadLifecycleListener,
StoreLifecycleListener,
SuspendableListener {
    private final PersistenceSessionLifecycleManagement persistenceSession;
    private boolean suspended;
    private static Map<Integer, LifecycleEventType> events = _Maps.newHashMap();

    public IsisLifecycleListener(PersistenceSessionLifecycleManagement persistenceSession) {
        this.persistenceSession = persistenceSession;
    }

    public void postCreate(InstanceLifecycleEvent event) {
    }

    public void preAttach(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.ensureRootObject(pojo);
    }

    public void postAttach(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.ensureRootObject(pojo);
    }

    public void postLoad(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.initializeMapAndCheckConcurrency(pojo);
    }

    public void preStore(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.invokeIsisPersistingCallback(pojo);
    }

    public void postStore(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.enlistCreatedAndRemapIfRequiredThenInvokeIsisInvokePersistingOrUpdatedCallback(pojo);
    }

    public void preDirty(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.enlistUpdatingAndInvokeIsisUpdatingCallback(pojo);
    }

    public void postDirty(InstanceLifecycleEvent event) {
    }

    public void preDelete(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.enlistDeletingAndInvokeIsisRemovingCallbackFacet(pojo);
    }

    public void postDelete(InstanceLifecycleEvent event) {
    }

    public void preClear(InstanceLifecycleEvent event) {
    }

    public void postClear(InstanceLifecycleEvent event) {
    }

    public void preDetach(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.ensureRootObject(pojo);
    }

    public void postDetach(InstanceLifecycleEvent event) {
        Persistable pojo = Utils.persistenceCapableFor(event);
        this.persistenceSession.ensureRootObject(pojo);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    private static enum LifecycleEventType {
        CREATE(0),
        LOAD(1),
        STORE(2),
        CLEAR(3),
        DELETE(4),
        DIRTY(5),
        DETACH(6),
        ATTACH(7);


        private LifecycleEventType(int code) {
            events.put(code, this);
        }
    }

    static interface PersistenceSessionLifecycleManagement {
        public void ensureRootObject(Persistable var1);

        public ObjectAdapter initializeMapAndCheckConcurrency(Persistable var1);

        public void enlistCreatedAndRemapIfRequiredThenInvokeIsisInvokePersistingOrUpdatedCallback(Persistable var1);

        public void invokeIsisPersistingCallback(Persistable var1);

        public void enlistUpdatingAndInvokeIsisUpdatingCallback(Persistable var1);

        public void enlistDeletingAndInvokeIsisRemovingCallbackFacet(Persistable var1);
    }
}

