/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.plugins.eventbus;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.isis.applib.events.domain.AbstractDomainEvent;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.plugins.eventbus.EventBusPlugin;
import org.apache.isis.core.runtime.services.eventbus.EventBusImplementationAbstract;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.AnnotationEventListenerAdapter;
import org.axonframework.eventhandling.EventListenerProxy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SimpleEventBus;

public class EventBusPluginForAxon
extends EventBusImplementationAbstract {
    private SimpleEventBus simpleEventBus = new SimpleEventBus();
    private Map<Object, AxonEventListenerAdapter> listenerAdapterByDomainService = new ConcurrentHashMap<Object, AxonEventListenerAdapter>();

    public void register(Object domainService) {
        AxonEventListenerAdapter adapter = this.lookupOrCreateAdapterFor(domainService);
        Registration registrationHandle = this.simpleEventBus.subscribe(this.eventProcessorFor(adapter));
        adapter.registration = registrationHandle;
    }

    public void unregister(Object domainService) {
        _With.acceptIfPresent((Object)((Object)this.lookupAdapterFor(domainService)), adapter -> _With.acceptIfPresent((Object)((AxonEventListenerAdapter)adapter).registration, Registration::cancel));
    }

    public void post(Object event) {
        this.simpleEventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)event)});
    }

    public <T> EventBusPlugin.EventListener<T> addEventListener(Class<T> targetType, Consumer<T> onEvent) {
        AxonEventListener eventListener = new AxonEventListener(targetType, onEvent);
        EventListenerProxy proxy = eventListener.proxy();
        Registration registrationHandle = this.simpleEventBus.subscribe(this.eventProcessorFor(proxy));
        eventListener.registration = registrationHandle;
        return eventListener;
    }

    public <T> void removeEventListener(EventBusPlugin.EventListener<T> eventListener) {
        if (eventListener instanceof AxonEventListener) {
            AxonEventListener listenerInstance = (AxonEventListener)eventListener;
            _With.acceptIfPresent((Object)listenerInstance.registration, Registration::cancel);
        }
    }

    protected AbstractDomainEvent<?> asDomainEvent(Object event) {
        if (event instanceof GenericEventMessage) {
            GenericEventMessage genericEventMessage = (GenericEventMessage)event;
            Object payload = genericEventMessage.getPayload();
            return this.asDomainEventIfPossible(payload);
        }
        return this.asDomainEventIfPossible(event);
    }

    private Consumer<List<? extends EventMessage<?>>> eventProcessorFor(EventListenerProxy proxy) {
        return eventMessages -> _NullSafe.stream((Collection)eventMessages).filter(arg_0 -> ((EventListenerProxy)proxy).canHandle(arg_0)).forEach(event -> {
            try {
                proxy.handle(event);
            }
            catch (Exception exception) {
                this.processException(exception, event);
            }
        });
    }

    private Consumer<List<? extends EventMessage<?>>> eventProcessorFor(AxonEventListenerAdapter adapter) {
        return eventMessages -> _NullSafe.stream((Collection)eventMessages).filter(arg_0 -> ((AxonEventListenerAdapter)adapter).canHandle(arg_0)).forEach(event -> {
            try {
                adapter.handle((EventMessage)event);
            }
            catch (Exception exception) {
                this.processException(exception, event);
            }
        });
    }

    private AxonEventListenerAdapter lookupOrCreateAdapterFor(Object domainService) {
        AxonEventListenerAdapter annotationEventListenerAdapter = this.lookupAdapterFor(domainService);
        if (annotationEventListenerAdapter == null) {
            annotationEventListenerAdapter = new AxonEventListenerAdapter(domainService);
            this.listenerAdapterByDomainService.put(domainService, annotationEventListenerAdapter);
        }
        return annotationEventListenerAdapter;
    }

    private AxonEventListenerAdapter lookupAdapterFor(Object domainService) {
        return this.listenerAdapterByDomainService.get(domainService);
    }

    private AbstractDomainEvent<?> asDomainEventIfPossible(Object event) {
        if (event instanceof AbstractDomainEvent) {
            return (AbstractDomainEvent)event;
        }
        return null;
    }

    class AxonEventListenerAdapter
    extends AnnotationEventListenerAdapter {
        private Registration registration;

        public AxonEventListenerAdapter(Object annotatedEventListener) {
            super(annotatedEventListener);
        }

        public void handle(EventMessage event) {
            try {
                super.handle(event);
            }
            catch (Exception exception) {
                EventBusPluginForAxon.this.processException(exception, event);
            }
        }
    }

    static class AxonEventListener<T>
    implements EventBusPlugin.EventListener<T> {
        private final Consumer<T> eventConsumer;
        private final EventListenerProxy proxy;
        private Registration registration;

        private AxonEventListener(final Class<T> targetType, Consumer<T> eventConsumer) {
            this.eventConsumer = Objects.requireNonNull(eventConsumer);
            this.proxy = new EventListenerProxy(){

                public void handle(EventMessage event) {
                    Object payload = event.getPayload();
                    if (payload == null) {
                        return;
                    }
                    if (targetType.isAssignableFrom(event.getPayloadType())) {
                        this.on(event.getPayload());
                    }
                }

                public Class<?> getTargetType() {
                    return targetType;
                }
            };
        }

        public void on(T event) {
            this.eventConsumer.accept(event);
        }

        public EventListenerProxy proxy() {
            return this.proxy;
        }
    }
}

