/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.plugins.codegen;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;

class ClassLoadingStrategyAdvisor {
    private final MethodHandle privateLookupMethodHandle = this.createPrivateLookupMethodHandle();

    ClassLoadingStrategyAdvisor() {
    }

    public ClassLoadingStrategy<ClassLoader> getSuitableStrategy(Class<?> targetClass) {
        if (this.privateLookupMethodHandle != null) {
            try {
                Object privateLookup = this.privateLookupMethodHandle.invoke(targetClass, MethodHandles.lookup());
                return ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
            }
            catch (Throwable e) {
                throw new IllegalStateException(String.format("Failed to utilize code generation strategy on class '%s'", targetClass.getName()), e);
            }
        }
        return ClassLoadingStrategy.Default.INJECTION;
    }

    private MethodHandle createPrivateLookupMethodHandle() {
        if (ClassInjector.UsingLookup.isAvailable()) {
            try {
                Class<MethodHandles> methodHandles = MethodHandles.class;
                Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                MethodHandle mh = MethodHandles.publicLookup().unreflect(privateLookupIn);
                return mh;
            }
            catch (Exception e) {
                throw new IllegalStateException("No code generation strategy available", e);
            }
        }
        if (ClassInjector.UsingReflection.isAvailable()) {
            return null;
        }
        throw new IllegalStateException("No code generation strategy available");
    }
}

