/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.prop.column;

import java.util.List;
import java.util.stream.Stream;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.isis.core.metamodel.JdoMetamodelUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.properties.property.maxlength.MaxLengthFacetForMaxLengthAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.maxlength.MaxLengthFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.MaxLengthFacetDerivedFromJdoColumn;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class MaxLengthDerivedFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public MaxLengthDerivedFromJdoColumnAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> cls = processMethodContext.getCls();
        if (!JdoMetamodelUtil.isPersistenceEnhanced(cls)) {
            return;
        }
        List<Column> annotations = Annotations.getAnnotations(processMethodContext.getMethod(), Column.class);
        if (String.class != processMethodContext.getMethod().getReturnType()) {
            return;
        }
        if (annotations.isEmpty()) {
            return;
        }
        Column annotation = annotations.get(0);
        if (annotation.length() == -1) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        MaxLengthFacet existingFacet = holder.getFacet(MaxLengthFacet.class);
        MaxLengthFacetDerivedFromJdoColumn facet = new MaxLengthFacetDerivedFromJdoColumn((Integer)annotation.length(), (FacetHolder)holder);
        if (!existingFacet.isNoop()) {
            facet.setUnderlyingFacet(existingFacet);
        }
        FacetUtil.addFacet(facet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    private MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                JdoPersistenceCapableFacet pcFacet = objectSpec.getFacet(JdoPersistenceCapableFacet.class);
                if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                    return;
                }
                Stream<ObjectAssociation> associations = objectSpec.streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
                associations.forEach(association -> {
                    if (association.containsDoOpFacet(JdoNotPersistentFacet.class)) {
                        return;
                    }
                    MaxLengthFacet facet = association.getFacet(MaxLengthFacet.class);
                    MaxLengthFacet underlying = (MaxLengthFacet)facet.getUnderlyingFacet();
                    if (underlying == null) {
                        return;
                    }
                    if (facet instanceof MaxLengthFacetDerivedFromJdoColumn && underlying instanceof MaxLengthFacetForMaxLengthAnnotationOnProperty && facet.value() != underlying.value()) {
                        validationFailures.add("%s: inconsistent lengths specified in Isis' @MaxLength(...) and @javax.jdo.annotations.Column(length=...); use just @javax.jdo.annotations.Column(length=...)", association.getIdentifier().toClassAndNameIdentityString());
                    }
                    if (facet instanceof MaxLengthFacetDerivedFromJdoColumn && underlying instanceof MaxLengthFacetForPropertyAnnotation && facet.value() != underlying.value()) {
                        validationFailures.add("%s: inconsistent lengths specified in Isis' @Property(maxLength=...) and @javax.jdo.annotations.Column(length=...); use just @javax.jdo.annotations.Column(length=...)", association.getIdentifier().toClassAndNameIdentityString());
                    }
                });
            }
        };
    }
}

