/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.prop.column;

import java.util.List;
import java.util.stream.Stream;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.JdoMetamodelUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacetAbstract;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacetDefault;
import org.apache.isis.core.metamodel.facets.properties.property.mandatory.MandatoryFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.MandatoryFacetDerivedFromJdoColumn;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.column.MandatoryFacetInferredFromAbsenceOfJdoColumn;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;
import org.apache.isis.objectstore.jdo.metamodel.facets.prop.primarykey.OptionalFacetDerivedFromJdoPrimaryKeyAnnotation;

public class MandatoryFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public MandatoryFromJdoColumnAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        List<Column> annotations;
        Class<?> cls = processMethodContext.getCls();
        if (!JdoMetamodelUtil.isPersistenceEnhanced(cls)) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        MandatoryFacet existingFacet = holder.getFacet(MandatoryFacet.class);
        if (existingFacet != null) {
            if (existingFacet instanceof OptionalFacetDerivedFromJdoPrimaryKeyAnnotation) {
                return;
            }
            if (existingFacet instanceof MandatoryFacetForPropertyAnnotation.Required) {
                return;
            }
        }
        Column annotation = (annotations = Annotations.getAnnotations(processMethodContext.getMethod(), Column.class)).isEmpty() ? null : annotations.get(0);
        boolean required = MandatoryFromJdoColumnAnnotationFacetFactory.whetherRequired(processMethodContext, annotation);
        MandatoryFacetAbstract facet = annotation != null ? new MandatoryFacetDerivedFromJdoColumn((FacetHolder)holder, required) : new MandatoryFacetInferredFromAbsenceOfJdoColumn((FacetHolder)holder, required);
        FacetUtil.addFacet(facet);
        if (facet instanceof MandatoryFacetDerivedFromJdoColumn && facet.getUnderlyingFacet() instanceof MandatoryFacetDefault) {
            facet.setUnderlyingFacet(null);
        }
    }

    private static boolean whetherRequired(FacetFactory.ProcessMethodContext processMethodContext, Column annotation) {
        String allowsNull;
        String string = allowsNull = annotation != null ? annotation.allowsNull() : null;
        if (_Strings.isNullOrEmpty((CharSequence)allowsNull)) {
            Class<?> returnType = processMethodContext.getMethod().getReturnType();
            return returnType != null && returnType.isPrimitive();
        }
        return !"true".equalsIgnoreCase(allowsNull.trim());
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    private MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                JdoPersistenceCapableFacet pcFacet = objectSpec.getFacet(JdoPersistenceCapableFacet.class);
                if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                    return;
                }
                Stream<ObjectAssociation> associations = objectSpec.streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
                associations.filter(association -> !association.containsDoOpFacet(JdoNotPersistentFacet.class)).forEach(association -> this.validateMandatoryFacet((ObjectAssociation)association, validationFailures));
            }

            private void validateMandatoryFacet(ObjectAssociation association, ValidationFailures validationFailures) {
                MandatoryFacet facet = association.getFacet(MandatoryFacet.class);
                MandatoryFacet underlying = (MandatoryFacet)facet.getUnderlyingFacet();
                if (underlying == null) {
                    return;
                }
                if (facet instanceof MandatoryFacetDerivedFromJdoColumn) {
                    if (association.isNotPersisted()) {
                        validationFailures.add("%s: @javax.jdo.annotations.Column found on non-persisted property; please remove)", association.getIdentifier().toClassAndNameIdentityString());
                        return;
                    }
                    if (underlying.isInvertedSemantics() == facet.isInvertedSemantics()) {
                        return;
                    }
                    if (underlying.isInvertedSemantics()) {
                        validationFailures.add("%s: incompatible usage of Isis' @Optional annotation and @javax.jdo.annotations.Column; use just @javax.jdo.annotations.Column(allowNulls=\"...\")", association.getIdentifier().toClassAndNameIdentityString());
                    } else {
                        validationFailures.add("%s: incompatible Isis' default of required/optional properties vs JDO; add @javax.jdo.annotations.Column(allowNulls=\"...\")", association.getIdentifier().toClassAndNameIdentityString());
                    }
                }
                if (facet instanceof MandatoryFacetInferredFromAbsenceOfJdoColumn) {
                    if (association.isNotPersisted()) {
                        return;
                    }
                    if (underlying.isInvertedSemantics() == facet.isInvertedSemantics()) {
                        return;
                    }
                    if (underlying.isInvertedSemantics()) {
                        validationFailures.add("%s: incompatible usage of Isis' @Optional annotation and @javax.jdo.annotations.Column; use just @javax.jdo.annotations.Column(allowNulls=\"...\")", association.getIdentifier().toClassAndNameIdentityString());
                    } else {
                        validationFailures.add("%s: incompatible default handling of required/optional properties between Isis and JDO; add @javax.jdo.annotations.Column(allowsNull=\"...\")", association.getIdentifier().toClassAndNameIdentityString());
                    }
                }
            }
        };
    }
}

