/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.query;

import java.util.List;
import java.util.Objects;
import org.apache.isis.core.metamodel.spec.Hierarchical;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.VisitorForClauseAbstract;

class VisitorForFromClause
extends VisitorForClauseAbstract {
    VisitorForFromClause(JdoQueryAnnotationFacetFactory specificationLoader) {
        super(specificationLoader, "FROM");
    }

    @Override
    String deriveClause(String query) {
        return JdoQueryAnnotationFacetFactory.from(query);
    }

    @Override
    void postInterpretJdoql(String classNameFromClause, ObjectSpecification objectSpec, String query, ValidationFailures validationFailures) {
        String className = objectSpec.getCorrespondingClass().getName();
        if (Objects.equals(classNameFromClause, className)) {
            return;
        }
        ObjectSpecification fromSpec = this.getSpecificationLoader().loadSpecification(classNameFromClause);
        List<ObjectSpecification> subclasses = fromSpec.subclasses(Hierarchical.Depth.TRANSITIVE);
        if (subclasses.contains(objectSpec)) {
            return;
        }
        validationFailures.add("%s: error in JDOQL query, class name after '%s' clause should be same as class name on which annotated, or one of its supertypes (JDOQL : %s)", className, this.clause, query);
    }
}

