/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.JdoMetamodelUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueriesFacetAnnotation;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryFacetAnnotation;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.VisitorForFromClause;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.VisitorForVariablesClause;

public class JdoQueryAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public static final String ISIS_REFLECTOR_VALIDATOR_JDOQL_FROM_CLAUSE_KEY = "isis.reflector.validator.jdoqlFromClause";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_JDOQL_FROM_CLAUSE_DEFAULT = true;
    public static final String ISIS_REFLECTOR_VALIDATOR_JDOQL_VARIABLES_CLAUSE_KEY = "isis.reflector.validator.jdoqlVariablesClause";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_JDOQL_VARIABLES_CLAUSE_DEFAULT = true;
    private static final Pattern fromPattern = Pattern.compile("SELECT.*?FROM[\\s]+([^\\s]+).*", 2);
    private static final Pattern variablesPattern = Pattern.compile(".*?VARIABLES[\\s]+([^\\s]+).*", 2);

    public JdoQueryAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        if (!JdoMetamodelUtil.isPersistenceEnhanced(cls)) {
            return;
        }
        Queries namedQueriesAnnotation = Annotations.getAnnotation(cls, Queries.class);
        Object facetHolder = processClassContext.getFacetHolder();
        if (namedQueriesAnnotation != null) {
            FacetUtil.addFacet(new JdoQueriesFacetAnnotation(namedQueriesAnnotation.value(), (FacetHolder)facetHolder));
            return;
        }
        Query namedQueryAnnotation = Annotations.getAnnotation(cls, Query.class);
        if (namedQueryAnnotation != null) {
            FacetUtil.addFacet(new JdoQueryFacetAnnotation(namedQueryAnnotation, (FacetHolder)facetHolder));
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        boolean validateVariablesClause;
        IsisConfiguration configuration = _Config.getConfiguration();
        boolean validateFromClause = configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_JDOQL_FROM_CLAUSE_KEY, true);
        if (validateFromClause) {
            MetaModelValidatorVisiting queryFromValidator = new MetaModelValidatorVisiting(new VisitorForFromClause(this));
            metaModelValidator.add(queryFromValidator);
        }
        if (validateVariablesClause = configuration.getBoolean(ISIS_REFLECTOR_VALIDATOR_JDOQL_VARIABLES_CLAUSE_KEY, true)) {
            MetaModelValidatorVisiting queryFromValidator = new MetaModelValidatorVisiting(new VisitorForVariablesClause(this));
            metaModelValidator.add(queryFromValidator);
        }
    }

    static String from(String query) {
        Matcher matcher = fromPattern.matcher(query);
        return matcher.matches() ? matcher.group(1) : null;
    }

    static String variables(String query) {
        Matcher matcher = variablesPattern.matcher(query);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    protected SpecificationLoader getSpecificationLoader() {
        return super.getSpecificationLoader();
    }
}

