/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authorization.standard;

import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.sudo.SudoService;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.runtime.authorization.AuthorizationManagerAbstract;
import org.apache.isis.core.runtime.authorization.standard.AuthorizationFacetFactory;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authorization.standard.Authorizor;

public class AuthorizationManagerStandard
extends AuthorizationManagerAbstract {
    private Authorizor authorizor = Authorizor.nop();

    public void init() {
        this.authorizor.init();
    }

    public void shutdown() {
        this.authorizor.shutdown();
    }

    public boolean isUsable(AuthenticationSession session, Identifier identifier) {
        if (this.isPerspectiveMember(identifier)) {
            return true;
        }
        if (AuthorizationManagerStandard.containsSudoSuperuserRole(session)) {
            return true;
        }
        if (this.authorizor.isUsableInAnyRole(identifier)) {
            return true;
        }
        for (String roleName : session.getRoles()) {
            if (!this.authorizor.isUsableInRole(roleName, identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible(AuthenticationSession session, Identifier identifier) {
        if (this.isPerspectiveMember(identifier)) {
            return true;
        }
        if (identifier.getMemberName().equals("")) {
            return true;
        }
        if (AuthorizationManagerStandard.containsSudoSuperuserRole(session)) {
            return true;
        }
        if (this.authorizor.isVisibleInAnyRole(identifier)) {
            return true;
        }
        for (String roleName : session.getRoles()) {
            if (!this.authorizor.isVisibleInRole(roleName, identifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSudoSuperuserRole(AuthenticationSession session) {
        List roles = session.getRoles();
        return roles != null && roles.contains(SudoService.ACCESS_ALL_ROLE);
    }

    private boolean isPerspectiveMember(Identifier identifier) {
        return identifier.getClassName().equals("");
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite baseMetaModelValidator) {
    }

    @Override
    public void refineProgrammingModel(ProgrammingModel baseProgrammingModel) {
        AuthorizationFacetFactory facetFactory = new AuthorizationFacetFactory(this);
        baseProgrammingModel.addFactory(facetFactory);
    }

    protected void setAuthorizor(Authorizor authorisor) {
        this.authorizor = authorisor;
    }
}

