/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.AppManifest2;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class MetaModelValidatorToCheckModuleExtent
extends MetaModelValidatorComposite {
    private static final String ISIS_REFLECTOR_CHECK_MODULE_EXTENT_KEY = "isis.reflector.validator.checkModuleExtent";
    private static final boolean ISIS_REFLECTOR_CHECK_MODULE_EXTENT_DEFAULT = true;

    public MetaModelValidatorToCheckModuleExtent() {
        this.addValidatorToCheckModuleExtent();
    }

    @Override
    public void validate(ValidationFailures validationFailures) {
        boolean check = this.specificationLoader.getConfiguration().getBoolean(ISIS_REFLECTOR_CHECK_MODULE_EXTENT_KEY, true);
        if (!check) {
            return;
        }
        AppManifest2 appManifest = ((MetaModelService)this.specificationLoader.getServicesInjector().lookupServiceElseFail(MetaModelService.class)).getAppManifest2();
        if (appManifest == null) {
            return;
        }
        super.validate(validationFailures);
    }

    private void addValidatorToCheckModuleExtent() {
        final TreeMap domainObjectClassNamesByPackage = _Maps.newTreeMap();
        MetaModelValidatorVisiting.SummarizingVisitor visitor = new MetaModelValidatorVisiting.SummarizingVisitor(){

            @Override
            public boolean visit(ObjectSpecification objSpec, ValidationFailures validationFailures) {
                Class<?> correspondingClass = objSpec.getCorrespondingClass();
                if (correspondingClass == null) {
                    return true;
                }
                Package aPackage = correspondingClass.getPackage();
                if (aPackage == null) {
                    return true;
                }
                String packageName = aPackage.getName();
                if (!(objSpec.isValue() || objSpec.isAbstract() || objSpec.isMixin() || objSpec.isParentedOrFreeCollection() || objSpec.getFullIdentifier().startsWith("java") || objSpec.getFullIdentifier().startsWith("org.joda") || objSpec.getFullIdentifier().startsWith("org.apache.isis"))) {
                    List classNames = (List)domainObjectClassNamesByPackage.get(packageName);
                    if (classNames == null) {
                        classNames = _Lists.newArrayList();
                        domainObjectClassNamesByPackage.put(packageName, classNames);
                    }
                    classNames.add(objSpec.getFullIdentifier());
                }
                return true;
            }

            @Override
            public void summarize(ValidationFailures validationFailures) {
                AppManifest2 appManifest = ((MetaModelService)MetaModelValidatorToCheckModuleExtent.this.specificationLoader.getServicesInjector().lookupServiceElseFail(MetaModelService.class)).getAppManifest2();
                if (appManifest == null) {
                    return;
                }
                Module topLevelModule = appManifest.getModule();
                if (topLevelModule == null) {
                    return;
                }
                Set<String> modulePackageNames = this.modulePackageNamesFrom((AppManifest)appManifest);
                Set domainObjectPackageNames = domainObjectClassNamesByPackage.keySet();
                for (String pkg : domainObjectPackageNames) {
                    List domainObjectClassNames = (List)domainObjectClassNamesByPackage.get(pkg);
                    boolean withinSomeModule = this.isWithinSomeModule(modulePackageNames, pkg);
                    if (withinSomeModule) continue;
                    String csv = _NullSafe.stream((Collection)domainObjectClassNames).collect(Collectors.joining(","));
                    validationFailures.add("Domain objects discovered in package '%s' are not in the set of modules obtained from the AppManifest's top-level module '%s'.  Classes are: %s", pkg, topLevelModule.getClass().getName(), csv);
                }
            }

            private Set<String> modulePackageNamesFrom(AppManifest appManifest) {
                List modules = appManifest.getModules();
                return modules.stream().map(aClass -> aClass.getPackage().getName()).collect(Collectors.toCollection(HashSet::new));
            }

            private boolean isWithinSomeModule(Set<String> modulePackageNames, String pkg) {
                for (String modulePackageName : modulePackageNames) {
                    if (!pkg.startsWith(modulePackageName)) continue;
                    return true;
                }
                return false;
            }
        };
        this.add(new MetaModelValidatorVisiting(visitor));
    }
}

