/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacetDefault;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorAbstract;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class MetaModelValidatorForConflictingOptionality
extends MetaModelValidatorAbstract {
    private final ValidationFailures failures = new ValidationFailures();

    @Override
    public void validate(ValidationFailures validationFailures) {
        validationFailures.addAll(this.failures);
    }

    private Facet addFailure(Facet facet, String message) {
        if (facet != null) {
            this.failures.add(message + ": " + ((IdentifiedHolder)facet.getFacetHolder()).getIdentifier().toFullIdentityString(), new Object[0]);
        }
        return facet;
    }

    public Facet flagIfConflict(MandatoryFacet facet, String message) {
        if (MetaModelValidatorForConflictingOptionality.conflictingOptionality(facet)) {
            this.addFailure(facet, message);
        }
        return facet;
    }

    private static boolean conflictingOptionality(MandatoryFacet facet) {
        if (facet == null) {
            return false;
        }
        MandatoryFacet underlyingFacet = (MandatoryFacet)facet.getUnderlyingFacet();
        if (underlyingFacet instanceof MandatoryFacetDefault) {
            return false;
        }
        boolean conflicting = underlyingFacet != null && facet.isInvertedSemantics() != underlyingFacet.isInvertedSemantics();
        return conflicting;
    }
}

