/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.collparam.semantics.CollectionSemantics;
import org.apache.isis.core.metamodel.facets.collparam.semantics.CollectionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.interactions.CollectionAddToContext;
import org.apache.isis.core.metamodel.interactions.CollectionRemoveFromContext;
import org.apache.isis.core.metamodel.interactions.CollectionUsabilityContext;
import org.apache.isis.core.metamodel.interactions.CollectionVisibilityContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectAssociationAbstract;

public class OneToManyAssociationDefault
extends ObjectAssociationAbstract
implements OneToManyAssociation {
    public OneToManyAssociationDefault(FacetedMethod facetedMethod, ServicesInjector servicesInjector) {
        this(facetedMethod, OneToManyAssociationDefault.getSpecification(servicesInjector.getSpecificationLoader(), facetedMethod.getType()), servicesInjector);
    }

    protected OneToManyAssociationDefault(FacetedMethod facetedMethod, ObjectSpecification objectSpec, ServicesInjector servicesInjector) {
        super(facetedMethod, FeatureType.COLLECTION, objectSpec, servicesInjector);
    }

    @Override
    public CollectionSemantics getCollectionSemantics() {
        CollectionSemanticsFacet facet = this.getFacet(CollectionSemanticsFacet.class);
        return facet != null ? (CollectionSemantics)((Object)facet.value()) : CollectionSemantics.OTHER_IMPLEMENTATION;
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(ManagedObject ownerAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return new CollectionVisibilityContext(ownerAdapter, this.getIdentifier(), interactionInitiatedBy, where);
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(ManagedObject ownerAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return new CollectionUsabilityContext(ownerAdapter, this.getIdentifier(), interactionInitiatedBy, where);
    }

    private ValidityContext<?> createValidateAddInteractionContext(InteractionInitiatedBy interactionInitiatedBy, ObjectAdapter ownerAdapter, ObjectAdapter proposedToAddAdapter) {
        return new CollectionAddToContext(ownerAdapter, this.getIdentifier(), proposedToAddAdapter, interactionInitiatedBy);
    }

    @Override
    public Consent isValidToAdd(ObjectAdapter ownerAdapter, ObjectAdapter proposedToAddAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return this.isValidToAddResult(ownerAdapter, proposedToAddAdapter, interactionInitiatedBy).createConsent();
    }

    private InteractionResult isValidToAddResult(ObjectAdapter ownerAdapter, ObjectAdapter proposedToAddAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ValidityContext<?> validityContext = this.createValidateAddInteractionContext(interactionInitiatedBy, ownerAdapter, proposedToAddAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    private ValidityContext<?> createValidateRemoveInteractionContext(ObjectAdapter ownerAdapter, ObjectAdapter proposedToRemoveAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return new CollectionRemoveFromContext(ownerAdapter, this.getIdentifier(), proposedToRemoveAdapter, interactionInitiatedBy);
    }

    @Override
    public Consent isValidToRemove(ObjectAdapter ownerAdapter, ObjectAdapter proposedToRemoveAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return this.isValidToRemoveResult(ownerAdapter, proposedToRemoveAdapter, interactionInitiatedBy).createConsent();
    }

    private InteractionResult isValidToRemoveResult(ObjectAdapter ownerAdapter, ObjectAdapter proposedToRemoveAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ValidityContext<?> validityContext = this.createValidateRemoveInteractionContext(ownerAdapter, proposedToRemoveAdapter, interactionInitiatedBy);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    private boolean readWrite() {
        return !this.isNotPersisted();
    }

    @Override
    public ObjectAdapter get(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        PropertyOrCollectionAccessorFacet accessor = this.getFacet(PropertyOrCollectionAccessorFacet.class);
        Object collection = accessor.getProperty(ownerAdapter, interactionInitiatedBy);
        if (collection == null) {
            return null;
        }
        return this.getObjectAdapterProvider().adapterFor(collection, (RootOid)ownerAdapter.getOid(), this);
    }

    @Override
    public boolean isEmpty(ObjectAdapter parentAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter collection = this.get(parentAdapter, interactionInitiatedBy);
        CollectionFacet facet = CollectionFacet.Utils.getCollectionFacetFromSpec(collection);
        return facet.size(collection) == 0;
    }

    @Override
    public void addElement(ObjectAdapter ownerAdapter, ObjectAdapter referencedAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        if (referencedAdapter == null) {
            throw new IllegalArgumentException("Can't use null to add an item to a collection");
        }
        if (this.readWrite()) {
            if (ownerAdapter.representsPersistent() && referencedAdapter.isTransient()) {
                throw new IsisException("can't set a reference to a transient object from a persistent one: " + ownerAdapter.titleString(null) + " (persistent) -> " + referencedAdapter.titleString() + " (transient)");
            }
            CollectionAddToFacet facet = this.getFacet(CollectionAddToFacet.class);
            facet.add(ownerAdapter, referencedAdapter, interactionInitiatedBy);
        }
    }

    @Override
    public void removeElement(ObjectAdapter ownerAdapter, ObjectAdapter referencedAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        if (referencedAdapter == null) {
            throw new IllegalArgumentException("element should not be null");
        }
        if (this.readWrite()) {
            CollectionRemoveFromFacet facet = this.getFacet(CollectionRemoveFromFacet.class);
            facet.remove(ownerAdapter, referencedAdapter, interactionInitiatedBy);
        }
    }

    public void removeAllAssociations(ObjectAdapter ownerAdapter) {
        CollectionClearFacet facet = this.getFacet(CollectionClearFacet.class);
        facet.clear(ownerAdapter);
    }

    @Override
    public void clearCollection(ObjectAdapter ownerAdapter) {
        if (this.readWrite()) {
            CollectionClearFacet facet = this.getFacet(CollectionClearFacet.class);
            facet.clear(ownerAdapter);
        }
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter ownerAdapter) {
        return null;
    }

    @Override
    public void toDefault(ObjectAdapter ownerAdapter) {
    }

    @Override
    public ObjectAdapter[] getChoices(ObjectAdapter ownerAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        return new ObjectAdapter[0];
    }

    @Override
    public boolean hasChoices() {
        return false;
    }

    @Override
    public boolean hasAutoComplete() {
        return false;
    }

    @Override
    public ObjectAdapter[] getAutoComplete(ObjectAdapter object, String searchArg, InteractionInitiatedBy interactionInitiatedBy) {
        return new ObjectAdapter[0];
    }

    @Override
    public int getAutoCompleteMinLength() {
        return 0;
    }

    @Override
    public String toString() {
        ToString str = new ToString(this);
        str.append(super.toString());
        str.append(",");
        str.append("persisted", !this.isNotPersisted());
        str.append("type", this.getSpecification() == null ? "unknown" : this.getSpecification().getShortIdentifier());
        return str.toString();
    }
}

