/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;

public abstract class ObjectAssociationAbstract
extends ObjectMemberAbstract
implements ObjectAssociation {
    private final ObjectSpecification specification;

    public ObjectAssociationAbstract(FacetedMethod facetedMethod, FeatureType featureType, ObjectSpecification specification, ServicesInjector servicesInjector) {
        super(facetedMethod, featureType, servicesInjector);
        if (specification == null) {
            throw new IllegalArgumentException("field type for '" + this.getId() + "' must exist");
        }
        this.specification = specification;
    }

    @Override
    public ObjectSpecification getOnType() {
        PropertyOrCollectionAccessorFacet facet = this.getFacet(PropertyOrCollectionAccessorFacet.class);
        return facet.getOnType();
    }

    @Override
    public ObjectSpecification getSpecification() {
        return this.specification;
    }

    @Override
    public boolean isNotPersisted() {
        return this.containsFacet(NotPersistedFacet.class);
    }

    @Override
    public boolean hasChoices() {
        return this.containsFacet(PropertyChoicesFacet.class);
    }

    @Override
    public boolean isMandatory() {
        MandatoryFacet mandatoryFacet = this.getFacet(MandatoryFacet.class);
        return mandatoryFacet != null && !mandatoryFacet.isInvertedSemantics();
    }

    @Override
    public abstract boolean isEmpty(ObjectAdapter var1, InteractionInitiatedBy var2);

    @Override
    public boolean isOneToOneAssociation() {
        return !this.isOneToManyAssociation();
    }
}

