/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.MethodUtil;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.object.facets.FacetsFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.IntrospectionState;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetedMethodsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FacetedMethodsBuilder.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private final ObjectSpecificationAbstract spec;
    private final Class<?> introspectedClass;
    private final List<Method> methods;
    private List<FacetedMethod> associationFacetMethods;
    private List<FacetedMethod> actionFacetedMethods;
    private final FacetedMethodsMethodRemover methodRemover;
    private final FacetProcessor facetProcessor;
    private final SpecificationTraverser specificationTraverser = new SpecificationTraverser();
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();
    private final SpecificationLoader specificationLoader;
    private final boolean explicitAnnotationsForActions;

    public FacetedMethodsBuilder(ObjectSpecificationAbstract spec, FacetedMethodsBuilderContext facetedMethodsBuilderContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating JavaIntrospector for {}", (Object)spec.getFullIdentifier());
        }
        this.spec = spec;
        this.introspectedClass = spec.getCorrespondingClass();
        this.methods = Arrays.asList(this.introspectedClass.getMethods());
        this.methodRemover = new FacetedMethodsMethodRemover(this.introspectedClass, this.methods);
        this.facetProcessor = facetedMethodsBuilderContext.facetProcessor;
        this.specificationLoader = facetedMethodsBuilderContext.specificationLoader;
        this.explicitAnnotationsForActions = _Config.getConfiguration().explicitAnnotationsForActions();
    }

    private String getClassName() {
        return this.introspectedClass.getName();
    }

    public void introspectObjectSpecId() {
        if (LOG.isInfoEnabled()) {
            LOG.info("introspecting {}: objectSpecId", (Object)this.getClassName());
        }
        this.getFacetProcessor().processObjectSpecId(this.introspectedClass, this.spec);
    }

    public void introspectClass() {
        if (LOG.isInfoEnabled()) {
            LOG.info("introspecting {}: class-level details", (Object)this.getClassName());
        }
        this.getFacetProcessor().process(this.introspectedClass, this.methodRemover, this.spec);
        FacetsFacet facetsFacet = this.spec.getFacet(FacetsFacet.class);
        if (facetsFacet != null) {
            Class<? extends FacetFactory>[] facetFactories;
            for (Class<? extends FacetFactory> facetFactorie : facetFactories = facetsFacet.facetFactories()) {
                FacetFactory facetFactory;
                try {
                    facetFactory = facetFactorie.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IsisException((Throwable)e);
                }
                this.getFacetProcessor().injectDependenciesInto(facetFactory);
                facetFactory.process(new FacetFactory.ProcessClassContext(this.introspectedClass, this.methodRemover, this.spec));
            }
        }
    }

    public List<FacetedMethod> getAssociationFacetedMethods() {
        if (this.associationFacetMethods == null) {
            this.associationFacetMethods = this.createAssociationFacetedMethods();
        }
        return this.associationFacetMethods;
    }

    private List<FacetedMethod> createAssociationFacetedMethods() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("introspecting {}: properties and collections", (Object)this.getClassName());
        }
        Set<Method> associationCandidateMethods = this.getFacetProcessor().findAssociationCandidateAccessors(this.methods, new HashSet<Method>());
        ArrayList typesToLoad = _Lists.newArrayList();
        for (Method method : associationCandidateMethods) {
            this.specificationTraverser.traverseTypes(method, typesToLoad);
        }
        this.getSpecificationLoader().loadSpecifications(typesToLoad, this.introspectedClass, IntrospectionState.TYPE_INTROSPECTED);
        ArrayList associationFacetedMethods = _Lists.newArrayList();
        this.findAndRemoveCollectionAccessorsAndCreateCorrespondingFacetedMethods(associationFacetedMethods);
        this.findAndRemovePropertyAccessorsAndCreateCorrespondingFacetedMethods(associationFacetedMethods);
        return Collections.unmodifiableList(associationFacetedMethods);
    }

    private void findAndRemoveCollectionAccessorsAndCreateCorrespondingFacetedMethods(List<FacetedMethod> associationPeers) {
        ArrayList collectionAccessors = _Lists.newArrayList();
        this.getFacetProcessor().findAndRemoveCollectionAccessors(this.methodRemover, collectionAccessors);
        this.createCollectionFacetedMethodsFromAccessors(collectionAccessors, associationPeers);
    }

    private void findAndRemovePropertyAccessorsAndCreateCorrespondingFacetedMethods(List<FacetedMethod> fields) {
        ArrayList propertyAccessors = _Lists.newArrayList();
        this.getFacetProcessor().findAndRemovePropertyAccessors(this.methodRemover, propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, GET_PREFIX, Object.class, 0, propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, IS_PREFIX, Boolean.class, 0, propertyAccessors);
        this.createPropertyFacetedMethodsFromAccessors(propertyAccessors, fields);
    }

    private void createCollectionFacetedMethodsFromAccessors(List<Method> accessorMethods, List<FacetedMethod> facetMethodsToAppendto) {
        for (Method accessorMethod : accessorMethods) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  identified accessor method representing collection: {}", (Object)accessorMethod);
            }
            FacetedMethod facetedMethod = FacetedMethod.createForCollection(this.introspectedClass, accessorMethod);
            this.getFacetProcessor().process(this.introspectedClass, accessorMethod, this.methodRemover, facetedMethod, FeatureType.COLLECTION);
            Class elementType = Object.class;
            TypeOfFacet typeOfFacet = facetedMethod.getFacet(TypeOfFacet.class);
            if (typeOfFacet != null) {
                elementType = typeOfFacet.value();
            }
            facetedMethod.setType(elementType);
            if (this.classSubstitutor.getClass(elementType) == null) continue;
            facetMethodsToAppendto.add(facetedMethod);
        }
    }

    private void createPropertyFacetedMethodsFromAccessors(List<Method> accessorMethods, List<FacetedMethod> facetedMethodsToAppendto) throws MetaModelException {
        for (Method accessorMethod : accessorMethods) {
            LOG.debug("  identified accessor method representing property: {}", (Object)accessorMethod);
            Class<?> returnType = accessorMethod.getReturnType();
            if (this.classSubstitutor.getClass(returnType) == null) continue;
            FacetedMethod facetedMethod = FacetedMethod.createForProperty(this.introspectedClass, accessorMethod);
            this.getFacetProcessor().process(this.introspectedClass, accessorMethod, this.methodRemover, facetedMethod, FeatureType.PROPERTY);
            facetedMethodsToAppendto.add(facetedMethod);
        }
    }

    public List<FacetedMethod> getActionFacetedMethods() {
        if (this.actionFacetedMethods == null) {
            this.actionFacetedMethods = this.findActionFacetedMethods(MethodScope.OBJECT);
        }
        return this.actionFacetedMethods;
    }

    private List<FacetedMethod> findActionFacetedMethods(MethodScope methodScope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("introspecting {}: actions", (Object)this.getClassName());
        }
        List<FacetedMethod> actionFacetedMethods1 = this.findActionFacetedMethods(methodScope, RecognisedHelpersStrategy.SKIP);
        List<FacetedMethod> actionFacetedMethods2 = this.findActionFacetedMethods(methodScope, RecognisedHelpersStrategy.DONT_SKIP);
        return ListExtensions.combineWith(actionFacetedMethods1, actionFacetedMethods2);
    }

    private List<FacetedMethod> findActionFacetedMethods(MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  looking for action methods");
        }
        ArrayList actionFacetedMethods = _Lists.newArrayList();
        for (int i = 0; i < this.methods.size(); ++i) {
            FacetedMethod actionPeer;
            Method method = this.methods.get(i);
            if (method == null || (actionPeer = this.findActionFacetedMethod(methodScope, recognisedHelpersStrategy, method)) == null) continue;
            this.methods.set(i, null);
            actionFacetedMethods.add(actionPeer);
        }
        return actionFacetedMethods;
    }

    private FacetedMethod findActionFacetedMethod(MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy, Method actionMethod) {
        if (!this.representsAction(actionMethod, methodScope, recognisedHelpersStrategy)) {
            return null;
        }
        return this.createActionFacetedMethod(actionMethod);
    }

    private FacetedMethod createActionFacetedMethod(Method actionMethod) {
        if (!this.isAllParamTypesValid(actionMethod)) {
            return null;
        }
        FacetedMethod action = FacetedMethod.createForAction(this.introspectedClass, actionMethod, this.getSpecificationLoader());
        this.getFacetProcessor().process(this.introspectedClass, actionMethod, this.methodRemover, action, FeatureType.ACTION);
        List<FacetedMethodParameter> actionParams = action.getParameters();
        for (int j = 0; j < actionParams.size(); ++j) {
            this.getFacetProcessor().processParams(this.introspectedClass, actionMethod, j, this.methodRemover, actionParams.get(j));
        }
        return action;
    }

    private boolean isAllParamTypesValid(Method actionMethod) {
        for (Class<?> paramType : actionMethod.getParameterTypes()) {
            ObjectSpecification paramSpec = this.getSpecificationLoader().loadSpecification(paramType);
            if (paramSpec != null) continue;
            return false;
        }
        return true;
    }

    private boolean representsAction(Method actionMethod, MethodScope methodScope, RecognisedHelpersStrategy recognisedHelpersStrategy) {
        if (!MethodUtil.inScope(actionMethod, methodScope)) {
            return false;
        }
        ArrayList typesToLoad = new ArrayList();
        this.specificationTraverser.traverseTypes(actionMethod, typesToLoad);
        boolean anyLoadedAsNull = this.getSpecificationLoader().loadSpecifications(typesToLoad, null, IntrospectionState.TYPE_INTROSPECTED);
        if (anyLoadedAsNull) {
            return false;
        }
        if (!this.loadParamSpecs(actionMethod)) {
            return false;
        }
        if (this.getFacetProcessor().recognizes(actionMethod)) {
            if (actionMethod.getName().startsWith("set")) {
                return false;
            }
            if (recognisedHelpersStrategy.skip()) {
                LOG.debug("  skipping possible helper method {0}", (Object)actionMethod);
                return false;
            }
        }
        if (this.explicitActionAnnotationConfigured() && !Annotations.isAnnotationPresent(actionMethod, Action.class)) {
            return false;
        }
        LOG.debug("  identified action {0}", (Object)actionMethod);
        return true;
    }

    private boolean explicitActionAnnotationConfigured() {
        return this.explicitAnnotationsForActions;
    }

    private boolean loadParamSpecs(Method actionMethod) {
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        return this.loadParamSpecs(parameterTypes);
    }

    private boolean loadParamSpecs(Class<?>[] parameterTypes) {
        int numParameters = parameterTypes.length;
        for (int j = 0; j < numParameters; ++j) {
            ObjectSpecification paramSpec = this.getSpecificationLoader().loadSpecification(parameterTypes[j]);
            if (paramSpec != null) continue;
            return false;
        }
        return true;
    }

    private void findAndRemovePrefixedNonVoidMethods(MethodScope methodScope, String prefix, Class<?> returnType, int paramCount, List<Method> methodListToAppendTo) {
        List<Method> matchingMethods = this.findAndRemovePrefixedMethods(methodScope, prefix, returnType, false, paramCount);
        methodListToAppendTo.addAll(matchingMethods);
    }

    private List<Method> findAndRemovePrefixedMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
        return MethodUtil.removeMethods(this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.getClassName());
        return str.toString();
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    private FacetProcessor getFacetProcessor() {
        return this.facetProcessor;
    }

    private static enum RecognisedHelpersStrategy {
        SKIP,
        DONT_SKIP;


        public boolean skip() {
            return this == SKIP;
        }
    }

    private static final class FacetedMethodsMethodRemover
    implements MethodRemover {
        private final Class<?> introspectedClass;
        private final List<Method> methods;

        private FacetedMethodsMethodRemover(Class<?> introspectedClass, List<Method> methods) {
            this.introspectedClass = introspectedClass;
            this.methods = methods;
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            MethodUtil.removeMethod(this.methods, methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return MethodUtil.removeMethods(this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(Method method) {
            if (method == null) {
                return;
            }
            for (int i = 0; i < this.methods.size(); ++i) {
                if (this.methods.get(i) == null || !this.methods.get(i).equals(method)) continue;
                this.methods.set(i, null);
            }
        }

        @Override
        public void removeMethods(List<Method> methodsToRemove) {
            block0: for (int i = 0; i < this.methods.size(); ++i) {
                if (this.methods.get(i) == null) continue;
                for (Method method : methodsToRemove) {
                    if (!this.methods.get(i).equals(method)) continue;
                    this.methods.set(i, null);
                    continue block0;
                }
            }
        }
    }
}

