/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.config.property.ConfigPropertyBoolean;
import org.apache.isis.config.property.ConfigPropertyEnum;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.FreeStandingList;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.IntrospectionMode;
import org.apache.isis.core.metamodel.specloader.SpecificationCacheDefault;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.facetprocessor.FacetProcessor;
import org.apache.isis.core.metamodel.specloader.postprocessor.PostProcessor;
import org.apache.isis.core.metamodel.specloader.specimpl.FacetedMethodsBuilderContext;
import org.apache.isis.core.metamodel.specloader.specimpl.IntrospectionState;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectSpecificationAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.standalonelist.ObjectSpecificationOnStandaloneList;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.runtime.threadpool.ThreadPoolExecutionMode;
import org.apache.isis.core.runtime.threadpool.ThreadPoolSupport;
import org.apache.isis.schema.utils.CommonDtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationLoader
implements ApplicationScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificationLoader.class);
    public static final ConfigPropertyBoolean CONFIG_PROPERTY_PARALLELIZE = new ConfigPropertyBoolean("isis.reflector.introspector.parallelize", true);
    public static final ConfigPropertyEnum<IntrospectionMode> CONFIG_PROPERTY_MODE = new ConfigPropertyEnum("isis.reflector.introspector.mode", (Enum)IntrospectionMode.LAZY_UNLESS_PRODUCTION);
    private final ClassSubstitutor classSubstitutor = new ClassSubstitutor();
    private final ProgrammingModel programmingModel;
    private final FacetProcessor facetProcessor;
    private final ServicesInjector servicesInjector;
    private final MetaModelValidator metaModelValidator;
    private final SpecificationCacheDefault cache = new SpecificationCacheDefault();
    private final PostProcessor postProcessor;
    private ValidationFailures validationFailures;

    public SpecificationLoader(ProgrammingModel programmingModel, MetaModelValidator metaModelValidator, ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
        this.programmingModel = programmingModel;
        this.metaModelValidator = metaModelValidator;
        this.facetProcessor = new FacetProcessor(programmingModel);
        this.postProcessor = new PostProcessor(programmingModel, servicesInjector);
    }

    @Programmatic
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialising {}", (Object)this);
        }
        this.facetProcessor.setServicesInjector(this.servicesInjector);
        this.programmingModel.init();
        this.facetProcessor.init();
        this.postProcessor.init();
        this.metaModelValidator.init(this);
        LOG.info("Loading all specs (up to state of {})", (Object)IntrospectionState.NOT_INTROSPECTED);
        ArrayList specificationsFromRegistry = _Lists.newArrayList();
        List<ObjectSpecification> domainServiceSpecs = this.loadSpecificationsFor(this.streamServiceClasses().collect(Collectors.toList()), NatureOfService.DOMAIN, specificationsFromRegistry, IntrospectionState.NOT_INTROSPECTED);
        List<ObjectSpecification> mixinSpecs = this.loadSpecificationsFor(AppManifest.Registry.instance().getMixinTypes(), null, specificationsFromRegistry, IntrospectionState.NOT_INTROSPECTED);
        this.loadSpecificationsFor(CommonDtoUtils.VALUE_TYPES, null, specificationsFromRegistry, IntrospectionState.NOT_INTROSPECTED);
        this.loadSpecificationsFor(AppManifest.Registry.instance().getDomainObjectTypes(), null, specificationsFromRegistry, IntrospectionState.NOT_INTROSPECTED);
        this.loadSpecificationsFor(AppManifest.Registry.instance().getViewModelTypes(), null, specificationsFromRegistry, IntrospectionState.NOT_INTROSPECTED);
        this.loadSpecificationsFor(AppManifest.Registry.instance().getXmlElementTypes(), null, specificationsFromRegistry, IntrospectionState.NOT_INTROSPECTED);
        this.cache.init();
        Collection<ObjectSpecification> cachedSpecifications = this.allCachedSpecifications();
        this.logBefore(specificationsFromRegistry, cachedSpecifications);
        LOG.info("Introspecting all specs up to {}", (Object)IntrospectionState.TYPE_INTROSPECTED);
        this.introspect(specificationsFromRegistry, IntrospectionState.TYPE_INTROSPECTED);
        LOG.info("Introspecting domainService specs up to {}", (Object)IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        this.introspect(domainServiceSpecs, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        LOG.info("Introspecting mixin specs up to {}", (Object)IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        this.introspect(mixinSpecs, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        this.logAfter(cachedSpecifications);
        IntrospectionMode mode = (IntrospectionMode)CONFIG_PROPERTY_MODE.from(this.getConfiguration());
        if (mode.isFullIntrospect(_Context.getEnvironment().getDeploymentType())) {
            LOG.info("Introspecting all cached specs up to {}", (Object)IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
            this.introspect(cachedSpecifications, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        }
        LOG.info("init() - done");
    }

    private void logBefore(List<ObjectSpecification> specificationsFromRegistry, Collection<ObjectSpecification> cachedSpecifications) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(String.format("specificationsFromRegistry.size = %d ; cachedSpecifications.size = %d", specificationsFromRegistry.size(), cachedSpecifications.size()));
        List registryNotCached = specificationsFromRegistry.stream().filter(spec -> !cachedSpecifications.contains(spec)).collect(Collectors.toList());
        List cachedNotRegistry = cachedSpecifications.stream().filter(spec -> !specificationsFromRegistry.contains(spec)).collect(Collectors.toList());
        LOG.debug(String.format("registryNotCached.size = %d ; cachedNotRegistry.size = %d", registryNotCached.size(), cachedNotRegistry.size()));
    }

    private void logAfter(Collection<ObjectSpecification> cachedSpecifications) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        Collection<ObjectSpecification> cachedSpecificationsAfter = this.cache.allSpecifications();
        List cachedAfterNotBefore = cachedSpecificationsAfter.stream().filter(spec -> !cachedSpecifications.contains(spec)).collect(Collectors.toList());
        LOG.debug(String.format("cachedSpecificationsAfter.size = %d ; cachedAfterNotBefore.size = %d", cachedSpecificationsAfter.size(), cachedAfterNotBefore.size()));
    }

    private void introspect(Collection<ObjectSpecification> specs, final IntrospectionState upTo) {
        ArrayList callables = _Lists.newArrayList();
        for (final ObjectSpecification specification : specs) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() {
                    ObjectSpecificationAbstract specSpi = (ObjectSpecificationAbstract)specification;
                    specSpi.introspectUpTo(upTo);
                    return null;
                }

                public String toString() {
                    return String.format("%s: #introspectUpTo( %s )", specification.getFullIdentifier(), upTo);
                }
            };
            callables.add(callable);
        }
        this.invokeAndWait(callables);
    }

    private void invokeAndWait(List<Callable<Object>> callables) {
        ThreadPoolSupport threadPoolSupport = ThreadPoolSupport.getInstance();
        boolean parallelize = CONFIG_PROPERTY_PARALLELIZE.from(this.getConfiguration());
        ThreadPoolExecutionMode executionModeFromConfig = parallelize ? ThreadPoolExecutionMode.PARALLEL : ThreadPoolExecutionMode.SEQUENTIAL;
        List<Future<Object>> futures = threadPoolSupport.invokeAll(executionModeFromConfig, callables);
        threadPoolSupport.joinGatherFailures(futures);
    }

    private List<ObjectSpecification> loadSpecificationsFor(Collection<Class<?>> domainTypes, NatureOfService natureOfServiceFallback, List<ObjectSpecification> appendTo, IntrospectionState upTo) {
        ArrayList specs = _Lists.newArrayList();
        for (Class<?> domainType : domainTypes) {
            ObjectSpecification objectSpecification = this.internalLoadSpecification(domainType, natureOfServiceFallback, upTo);
            if (objectSpecification == null) continue;
            specs.add(objectSpecification);
        }
        appendTo.addAll(specs);
        return specs;
    }

    @Programmatic
    public void shutdown() {
        LOG.info("shutting down {}", (Object)this);
        this.cache.clear();
    }

    @Programmatic
    public void invalidateCache(Class<?> cls) {
        if (!this.cache.isInitialized()) {
            return;
        }
        Class<?> substitutedType = this.classSubstitutor.getClass(cls);
        if (substitutedType.isAnonymousClass()) {
            return;
        }
        for (ObjectSpecification spec = this.loadSpecification(substitutedType, IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED); spec != null; spec = spec.superclass()) {
            Class<?> type = spec.getCorrespondingClass();
            this.cache.remove(type.getName());
            if (!spec.containsDoOpFacet(ObjectSpecIdFacet.class)) continue;
            this.recache(spec);
        }
    }

    private void recache(ObjectSpecification newSpec) {
        this.cache.recache(newSpec);
    }

    @Programmatic
    public void validateAndAssert() {
        IntrospectionMode mode = (IntrospectionMode)CONFIG_PROPERTY_MODE.from(this.getConfiguration());
        if (!mode.isFullIntrospect(_Context.getEnvironment().getDeploymentType())) {
            LOG.info("Meta model validation skipped (full introspection of metamodel not configured)");
            return;
        }
        ValidationFailures validationFailures = this.validate();
        validationFailures.assertNone();
    }

    @Programmatic
    public ValidationFailures validate() {
        if (this.validationFailures == null) {
            this.validationFailures = new ValidationFailures();
            this.metaModelValidator.validate(this.validationFailures);
        }
        return this.validationFailures;
    }

    @Programmatic
    public ObjectSpecification loadSpecification(String className) {
        return this.loadSpecification(className, IntrospectionState.TYPE_INTROSPECTED);
    }

    @Programmatic
    public ObjectSpecification loadSpecification(String className, IntrospectionState upTo) {
        assert (className != null);
        try {
            Class<?> cls = this.loadBuiltIn(className);
            return this.internalLoadSpecification(cls, null, upTo);
        }
        catch (ClassNotFoundException e) {
            ObjectSpecification spec = this.cache.get(className);
            if (spec == null) {
                throw new IsisException("No such class available: " + className);
            }
            return spec;
        }
    }

    @Programmatic
    public ObjectSpecification loadSpecification(Class<?> type) {
        return this.loadSpecification(type, IntrospectionState.TYPE_INTROSPECTED);
    }

    @Programmatic
    public ObjectSpecification peekSpecification(Class<?> type) {
        Class<?> substitutedType = this.classSubstitutor.getClass(type);
        if (substitutedType == null) {
            return null;
        }
        String typeName = substitutedType.getName();
        ObjectSpecification spec = this.cache.get(typeName);
        if (spec != null) {
            return spec;
        }
        return null;
    }

    @Programmatic
    public ObjectSpecification loadSpecification(Class<?> type, IntrospectionState upTo) {
        ObjectSpecId specId;
        ObjectSpecification spec = this.internalLoadSpecification(type, null, upTo);
        if (spec == null) {
            return null;
        }
        if (this.cache.isInitialized() && spec.containsDoOpFacet(ObjectSpecIdFacet.class) && this.cache.getByObjectType(specId = spec.getSpecId()) == null) {
            this.cache.recache(spec);
        }
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSpecification internalLoadSpecification(Class<?> type, NatureOfService natureFallback, IntrospectionState upTo) {
        Class<?> substitutedType = this.classSubstitutor.getClass(type);
        if (substitutedType == null) {
            return null;
        }
        Assert.assertNotNull(substitutedType);
        String typeName = substitutedType.getName();
        ObjectSpecification spec = this.cache.get(typeName);
        if (spec != null) {
            return spec;
        }
        SpecificationLoader specificationLoader = this;
        synchronized (specificationLoader) {
            spec = this.cache.get(typeName);
            if (spec != null) {
                return spec;
            }
            ObjectSpecification specification = this.createSpecification(substitutedType, natureFallback);
            this.cache.cache(typeName, specification);
            ObjectSpecificationAbstract specSpi = (ObjectSpecificationAbstract)specification;
            specSpi.introspectUpTo(upTo);
            return specification;
        }
    }

    @Programmatic
    public boolean loadSpecifications(List<Class<?>> typesToLoad, Class<?> typeToIgnore, IntrospectionState upTo) {
        boolean anyLoadedAsNull = false;
        for (Class<?> typeToLoad : typesToLoad) {
            if (typeToLoad == typeToIgnore) continue;
            ObjectSpecification objectSpecification = this.internalLoadSpecification(typeToLoad, null, upTo);
            boolean loadedAsNull = objectSpecification == null;
            anyLoadedAsNull = loadedAsNull || anyLoadedAsNull;
        }
        return anyLoadedAsNull;
    }

    private ObjectSpecification createSpecification(Class<?> cls, NatureOfService fallback) {
        ObjectSpecificationAbstract objectSpec;
        if (FreeStandingList.class.isAssignableFrom(cls)) {
            objectSpec = new ObjectSpecificationOnStandaloneList(this.servicesInjector, this.facetProcessor, this.postProcessor);
        } else {
            FacetedMethodsBuilderContext facetedMethodsBuilderContext = new FacetedMethodsBuilderContext(this, this.facetProcessor);
            NatureOfService natureOfServiceIfAny = this.natureOfServiceFrom(cls, fallback);
            objectSpec = new ObjectSpecificationDefault(cls, facetedMethodsBuilderContext, this.servicesInjector, this.facetProcessor, natureOfServiceIfAny, this.postProcessor);
        }
        return objectSpec;
    }

    private NatureOfService natureOfServiceFrom(Class<?> type, NatureOfService fallback) {
        DomainService domainServiceIfAny = type.getAnnotation(DomainService.class);
        return domainServiceIfAny != null ? domainServiceIfAny.nature() : fallback;
    }

    private Class<?> loadBuiltIn(String className) throws ClassNotFoundException {
        Class<?> builtIn = ClassUtil.getBuiltIn(className);
        if (builtIn != null) {
            return builtIn;
        }
        return ClassUtil.forName(className);
    }

    @Programmatic
    public List<ObjectSpecification> allSpecifications() {
        return _Lists.newArrayList(this.allCachedSpecifications());
    }

    private Collection<ObjectSpecification> allCachedSpecifications() {
        return this.cache.allSpecifications();
    }

    @Programmatic
    public Stream<Class<?>> streamServiceClasses() {
        return this.servicesInjector.streamServiceTypes();
    }

    @Programmatic
    public boolean isServiceClass(Class<?> cls) {
        ObjectSpecification objectSpecification = this.peekSpecification(cls);
        return objectSpecification != null && objectSpecification.containsDoOpFacet(DomainServiceFacet.class);
    }

    @Programmatic
    public boolean loaded(Class<?> cls) {
        return this.loaded(cls.getName());
    }

    @Programmatic
    public boolean loaded(String fullyQualifiedClassName) {
        return this.cache.get(fullyQualifiedClassName) != null;
    }

    @Programmatic
    public ObjectSpecification lookupBySpecId(ObjectSpecId objectSpecId) {
        if (!this.cache.isInitialized()) {
            throw new IllegalStateException("Internal cache not yet initialized");
        }
        ObjectSpecification objectSpecification = this.cache.getByObjectType(objectSpecId);
        if (objectSpecification == null) {
            return this.loadSpecification(objectSpecId.asString(), IntrospectionState.TYPE_AND_MEMBERS_INTROSPECTED);
        }
        return objectSpecification;
    }

    @Programmatic
    public IsisConfiguration getConfiguration() {
        return _Config.getConfiguration();
    }

    @Programmatic
    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }
}

