/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import io.swagger.models.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.services.swagger.internal.Caching;
import org.apache.isis.core.metamodel.services.swagger.internal.ClassExcluder;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public final class Util {
    private Util() {
    }

    static boolean isVisibleForPublic(ObjectAction objectAction) {
        ObjectSpecification elementSpec;
        TypeOfFacet typeOfFacet;
        ObjectSpecification specification = objectAction.getReturnType();
        boolean visible = Util.isVisibleForPublic(specification);
        if (!visible && (typeOfFacet = objectAction.getFacet(TypeOfFacet.class)) != null && !Util.isVisibleForPublic(elementSpec = typeOfFacet.valueSpec())) {
            return false;
        }
        List<ObjectSpecification> parameterTypes = objectAction.getParameterTypes();
        for (ObjectSpecification parameterType : parameterTypes) {
            boolean paramVisible = Util.isVisibleForPublic(parameterType);
            if (paramVisible) continue;
            return false;
        }
        return true;
    }

    static boolean isVisibleForPublic(ObjectAssociation objectAssociation) {
        ObjectSpecification specification = objectAssociation.getSpecification();
        return Util.isVisibleForPublic(specification);
    }

    static boolean isVisibleForPublic(ObjectSpecification specification) {
        TypeOfFacet typeOfFacet;
        if (specification == null) {
            return true;
        }
        if (specification.isViewModel()) {
            return true;
        }
        if (specification.isValue()) {
            return true;
        }
        if (specification.isParentedOrFreeCollection() && (typeOfFacet = specification.getFacet(TypeOfFacet.class)) != null) {
            ObjectSpecification elementSpec = typeOfFacet.valueSpec();
            return Util.isVisibleForPublic(elementSpec);
        }
        Class<?> correspondingClass = specification.getCorrespondingClass();
        return Collection.class.isAssignableFrom(correspondingClass) || correspondingClass.isArray() || correspondingClass == Void.TYPE || correspondingClass == Void.class;
    }

    static Predicate<ObjectAssociation> associationsWith(final SwaggerService.Visibility visibility) {
        return new Predicate<ObjectAssociation>(){

            @Override
            public boolean test(ObjectAssociation objectAssociation) {
                return !visibility.isPublic() || Util.isVisibleForPublic(objectAssociation);
            }
        };
    }

    static List<OneToOneAssociation> propertiesOf(ObjectSpecification objectSpecification, SwaggerService.Visibility visibility) {
        return Util.associationsOf(objectSpecification, ObjectAssociation.Predicates.PROPERTIES, visibility);
    }

    static List<OneToManyAssociation> collectionsOf(ObjectSpecification objectSpecification, SwaggerService.Visibility visibility) {
        return Util.associationsOf(objectSpecification, ObjectAssociation.Predicates.COLLECTIONS, visibility);
    }

    private static <T extends ObjectAssociation> List<T> associationsOf(ObjectSpecification objectSpecification, Predicate<ObjectAssociation> associationPredicate, SwaggerService.Visibility visibility) {
        List list = objectSpecification.streamAssociations(Contributed.INCLUDED).filter(associationPredicate.and(Util.associationsWith(visibility))).collect(Collectors.toList());
        return (List)_Casts.uncheckedCast(list);
    }

    static List<ObjectAction> actionsOf(ObjectSpecification objectSpec, SwaggerService.Visibility visibility, ClassExcluder classExcluder) {
        List<ActionType> actionTypes = Util.actionTypesFor(visibility);
        return objectSpec.streamObjectActions(actionTypes, Contributed.INCLUDED).filter(objectAction -> !classExcluder.exclude((ObjectAction)objectAction) && !visibility.isPublic() || Util.isVisibleForPublic(objectAction)).collect(Collectors.toList());
    }

    static String roSpec(String section) {
        return "RO Spec v1.0, section " + section;
    }

    static Response withCachingHeaders(Response response, Caching caching) {
        caching.withHeaders(response);
        return response;
    }

    static List<ActionType> actionTypesFor(SwaggerService.Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return Arrays.asList(ActionType.USER);
            }
            case PRIVATE: {
                return Arrays.asList(ActionType.USER);
            }
            case PRIVATE_WITH_PROTOTYPING: {
                return Arrays.asList(ActionType.USER, ActionType.PROTOTYPE);
            }
        }
        throw new IllegalArgumentException("Unrecognized type '" + visibility + "'");
    }
}

