/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.PersistFailedException;
import org.apache.isis.applib.RepositoryException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class RepositoryServiceInternalDefault
implements RepositoryService {
    private boolean autoFlush;
    @Inject
    FactoryService factoryService;
    @Inject
    WrapperFactory wrapperFactory;
    @Inject
    TransactionService transactionService;
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    @Programmatic
    @PostConstruct
    public void init() {
        boolean disableAutoFlush = _Config.getConfiguration().getBoolean("isis.services.container.disableAutoFlush", false);
        this.autoFlush = !disableAutoFlush;
    }

    @Programmatic
    public <T> T instantiate(Class<T> domainClass) {
        return (T)this.factoryService.instantiate(domainClass);
    }

    @Programmatic
    public boolean isPersistent(Object domainObject) {
        ObjectAdapter adapter = this.getObjectAdapterProvider().adapterFor(this.unwrapped(domainObject));
        return adapter.representsPersistent();
    }

    @Programmatic
    public boolean isDeleted(Object domainObject) {
        ObjectAdapter adapter = this.getObjectAdapterProvider().adapterFor(this.unwrapped(domainObject));
        return adapter.isDestroyed();
    }

    @Programmatic
    public <T> T persist(T object) {
        if (this.isPersistent(object)) {
            return object;
        }
        ObjectAdapter adapter = this.getObjectAdapterProvider().adapterFor(this.unwrapped(object));
        if (adapter == null) {
            throw new PersistFailedException("Object not known to framework (unable to create/obtain an adapter)");
        }
        if (adapter.isParentedCollection()) {
            return object;
        }
        if (this.isPersistent(object)) {
            throw new PersistFailedException("Object already persistent; OID=" + adapter.getOid());
        }
        this.persistenceSessionServiceInternal.makePersistent(adapter);
        return object;
    }

    @Programmatic
    public <T> T persistAndFlush(T object) {
        this.persist(object);
        this.transactionService.flushTransaction();
        return object;
    }

    @Programmatic
    public void remove(Object domainObject) {
        this.removeIfNotAlready(domainObject);
    }

    private void removeIfNotAlready(Object object) {
        if (!this.isPersistent(object)) {
            return;
        }
        if (object == null) {
            throw new IllegalArgumentException("Must specify a reference for disposing an object");
        }
        ObjectAdapter adapter = this.getObjectAdapterProvider().adapterFor(this.unwrapped(object));
        if (!this.isPersistent(object)) {
            throw new RepositoryException("Object not persistent: " + adapter);
        }
        this.persistenceSessionServiceInternal.remove(adapter);
    }

    @Programmatic
    public void removeAndFlush(Object domainObject) {
        this.remove(domainObject);
        this.transactionService.flushTransaction();
    }

    @Programmatic
    public <T> List<T> allInstances(Class<T> type, long ... range) {
        return this.allMatches((Query<T>)new QueryFindAllInstances(type, range));
    }

    @Programmatic
    public <T> List<T> allMatches(Class<T> ofType, Predicate<? super T> predicate, long ... range) {
        return _NullSafe.stream(this.allInstances(ofType, range)).filter(predicate).collect(Collectors.toCollection(ArrayList::new));
    }

    @Programmatic
    public <T> List<T> allMatches(Query<T> query) {
        if (this.autoFlush) {
            this.transactionService.flushTransaction();
        }
        return this.submitQuery(query);
    }

    <T> List<T> submitQuery(Query<T> query) {
        List<ObjectAdapter> allMatching = this.persistenceSessionServiceInternal.allMatchingQuery(query);
        return ObjectAdapter.Util.unwrapTypedPojoList(allMatching);
    }

    @Programmatic
    public <T> T uniqueMatch(Class<T> type, Predicate<T> predicate) {
        List<T> instances = this.allMatches(type, predicate, 0L, 2L);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more than one instance of " + type + " matching filter " + predicate);
        }
        return RepositoryServiceInternalDefault.firstInstanceElseNull(instances);
    }

    @Programmatic
    public <T> T uniqueMatch(Query<T> query) {
        List<T> instances = this.allMatches(query);
        if (instances.size() > 1) {
            throw new RepositoryException("Found more that one instance for query:" + query.getDescription());
        }
        return RepositoryServiceInternalDefault.firstInstanceElseNull(instances);
    }

    private static <T> T firstInstanceElseNull(List<T> instances) {
        return instances.size() == 0 ? null : (T)instances.get(0);
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    private ObjectAdapterProvider getObjectAdapterProvider() {
        return this.persistenceSessionServiceInternal;
    }
}

