/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.grid;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.services.grid.GridLoaderService2;
import org.apache.isis.applib.services.grid.GridSystemService;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.resources._Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class GridLoaderServiceDefault
implements GridLoaderService2 {
    private static final Logger LOG = LoggerFactory.getLogger(GridLoaderServiceDefault.class);
    private final Map<DomainClassAndLayout, String> badXmlByDomainClassAndLayout = _Maps.newHashMap();
    private final Map<DomainClassAndLayoutAndXml, Grid> gridByDomainClassAndLayoutAndXml = _Maps.newHashMap();
    private JAXBContext jaxbContext;
    @Inject
    MessageService messageService;
    @Inject
    JaxbService jaxbService;
    @Inject
    List<GridSystemService<?>> gridSystemServices;

    @PostConstruct
    public void init() {
        Class[] pageImplementations = (Class[])_NullSafe.stream(this.gridSystemServices).map(GridSystemService::gridImplementation).collect(_Arrays.toArray(Class.class));
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])pageImplementations);
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public boolean supportsReloading() {
        return _Context.isPrototyping();
    }

    public void remove(Class<?> domainClass) {
        String layoutIfAny = null;
        DomainClassAndLayout dcal = new DomainClassAndLayout(domainClass, layoutIfAny);
        if (!this.supportsReloading()) {
            return;
        }
        this.badXmlByDomainClassAndLayout.remove(dcal);
        String xml = this.loadXml(dcal);
        if (xml == null) {
            return;
        }
        this.gridByDomainClassAndLayoutAndXml.remove(new DomainClassAndLayoutAndXml(dcal, xml));
    }

    @Programmatic
    public boolean existsFor(Class<?> domainClass) {
        return this.resourceNameFor(new DomainClassAndLayout(domainClass, null)) != null;
    }

    public Grid load(Class<?> domainClass, String layoutIfAny) {
        Grid grid;
        DomainClassAndLayout dcal = new DomainClassAndLayout(domainClass, layoutIfAny);
        String xml = this.loadXml(dcal);
        if (xml == null) {
            return null;
        }
        DomainClassAndLayoutAndXml dcalax = new DomainClassAndLayoutAndXml(dcal, xml);
        if (this.supportsReloading()) {
            grid = this.gridByDomainClassAndLayoutAndXml.get(dcalax);
            if (grid != null) {
                return grid;
            }
            String badXml = this.badXmlByDomainClassAndLayout.get(dcal);
            if (badXml != null) {
                if (Objects.equals(xml, badXml)) {
                    return null;
                }
                this.badXmlByDomainClassAndLayout.remove(dcal);
            }
        }
        try {
            if (this.jaxbContext == null) {
                return null;
            }
            grid = (Grid)this.jaxbService.fromXml(this.jaxbContext, xml);
            grid.setDomainClass(domainClass);
            if (this.supportsReloading()) {
                this.gridByDomainClassAndLayoutAndXml.put(dcalax, grid);
            }
            return grid;
        }
        catch (Exception ex) {
            if (this.supportsReloading()) {
                this.badXmlByDomainClassAndLayout.put(dcal, xml);
            }
            String resourceName = this.resourceNameFor(dcal);
            String message = "Failed to parse " + resourceName + " file (" + ex.getMessage() + ")";
            if (this.supportsReloading()) {
                this.messageService.warnUser(message);
            }
            LOG.warn(message);
            return null;
        }
    }

    @Programmatic
    public Grid load(Class<?> domainClass) {
        return this.load(domainClass, null);
    }

    private String loadXml(DomainClassAndLayout dcal) {
        String resourceName = this.resourceNameFor(dcal);
        if (resourceName == null) {
            LOG.debug("Failed to locate layout file for '{}'", (Object)dcal.toString());
            return null;
        }
        try {
            return GridLoaderServiceDefault.resourceContentOf(dcal, resourceName);
        }
        catch (IOException ex) {
            LOG.debug("Failed to locate file {} (relative to {}.class)", new Object[]{resourceName, dcal.domainClass.getName(), ex});
            return null;
        }
    }

    private static String resourceContentOf(DomainClassAndLayout dcal, String resourceName) throws IOException {
        return _Resources.loadAsString((Class)dcal.domainClass, (String)resourceName, (Charset)Charset.defaultCharset());
    }

    String resourceNameFor(DomainClassAndLayout dcal) {
        ArrayList candidateResourceNames = _Lists.newArrayList();
        if (dcal.layoutIfAny != null) {
            candidateResourceNames.add(String.format("%s-%s.layout.xml", dcal.domainClass.getSimpleName(), dcal.layoutIfAny));
        }
        candidateResourceNames.add(String.format("%s.layout.xml", dcal.domainClass.getSimpleName()));
        candidateResourceNames.add(String.format("%s.layout.fallback.xml", dcal.domainClass.getSimpleName()));
        for (String candidateResourceName : candidateResourceNames) {
            try {
                URL resource = _Resources.getResourceUrl((Class)dcal.domainClass, (String)candidateResourceName);
                if (resource == null) continue;
                return candidateResourceName;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    static class DomainClassAndLayoutAndXml {
        private final DomainClassAndLayout domainClassAndLayout;
        private final String xml;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomainClassAndLayoutAndXml that = (DomainClassAndLayoutAndXml)o;
            if (this.domainClassAndLayout != null ? !this.domainClassAndLayout.equals(that.domainClassAndLayout) : that.domainClassAndLayout != null) {
                return false;
            }
            return this.xml != null ? this.xml.equals(that.xml) : that.xml == null;
        }

        public int hashCode() {
            int result = this.domainClassAndLayout != null ? this.domainClassAndLayout.hashCode() : 0;
            result = 31 * result + (this.xml != null ? this.xml.hashCode() : 0);
            return result;
        }

        DomainClassAndLayoutAndXml(DomainClassAndLayout domainClassAndLayout, String xml) {
            this.domainClassAndLayout = domainClassAndLayout;
            this.xml = xml;
        }
    }

    static class DomainClassAndLayout {
        private final Class<?> domainClass;
        private final String layoutIfAny;

        DomainClassAndLayout(Class<?> domainClass, String layoutIfAny) {
            this.domainClass = domainClass;
            this.layoutIfAny = layoutIfAny;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomainClassAndLayout that = (DomainClassAndLayout)o;
            if (this.domainClass != null ? !this.domainClass.equals(that.domainClass) : that.domainClass != null) {
                return false;
            }
            return this.layoutIfAny != null ? this.layoutIfAny.equals(that.layoutIfAny) : that.layoutIfAny == null;
        }

        public int hashCode() {
            int result = this.domainClass != null ? this.domainClass.hashCode() : 0;
            result = 31 * result + (this.layoutIfAny != null ? this.layoutIfAny.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "domainClass=" + this.domainClass + ", layout='" + this.layoutIfAny + '\'';
        }
    }
}

