/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.functions._Functions;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    public static String idOfPojo(Object serviceObject) {
        Class<?> serviceClass = serviceObject.getClass();
        return ServiceUtil.explicitIdOfType(serviceClass, (_Functions.CheckedSupplier<Object>)((_Functions.CheckedSupplier)() -> serviceObject)).orElseGet(() -> ServiceUtil.normalize(serviceClass));
    }

    public static String idOfSpec(ObjectSpecification serviceSpec) {
        Class<?> serviceClass = serviceSpec.getCorrespondingClass();
        return ServiceUtil.explicitIdOfType(serviceClass, (_Functions.CheckedSupplier<Object>)((_Functions.CheckedSupplier)serviceClass::newInstance)).orElseGet(() -> ServiceUtil.normalize(serviceClass));
    }

    public static String idOfAdapter(ManagedObject serviceAdapter) {
        return ServiceUtil.idOfPojo(serviceAdapter.getPojo());
    }

    public static Optional<String> getExplicitIdOfType(Class<?> serviceClass) {
        return ServiceUtil.explicitIdOfType(serviceClass, (_Functions.CheckedSupplier<Object>)((_Functions.CheckedSupplier)serviceClass::newInstance));
    }

    private static Optional<String> explicitIdOfType(Class<?> serviceClass, _Functions.CheckedSupplier<Object> serviceInstanceSupplier) {
        String serviceType = ServiceUtil.serviceTypeUsingAnnotation(serviceClass);
        if (serviceType != null) {
            return Optional.of(serviceType);
        }
        return ServiceUtil.serviceTypeUsingIdGetter(serviceClass, serviceInstanceSupplier);
    }

    private static String serviceTypeUsingAnnotation(Class<?> serviceClass) {
        String serviceType;
        DomainService domainService = serviceClass.getAnnotation(DomainService.class);
        if (domainService != null && !_Strings.isNullOrEmpty((CharSequence)(serviceType = domainService.objectType()))) {
            return serviceType;
        }
        return null;
    }

    private static Optional<String> serviceTypeUsingIdGetter(Class<?> serviceClass, _Functions.CheckedSupplier<Object> serviceInstanceSupplier) {
        try {
            Method m = serviceClass.getMethod("getId", new Class[0]);
            return Optional.ofNullable((String)m.invoke(serviceInstanceSupplier.get(), new Object[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static String normalize(Class<?> serviceClass) {
        return serviceClass.getName();
    }
}

