/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class CollectionHelper {
    CollectionHelper() {
    }

    static void ifIsCollectionWithGenericTypeThen(Field field, Consumer<Class<?>> action) {
        Type genericType;
        Class<?> typeToBeInjected = field.getType();
        if (Collection.class.isAssignableFrom(typeToBeInjected) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Class elementType = (Class)parameterizedType.getActualTypeArguments()[0];
            action.accept(elementType);
        }
    }

    static <T> Collection<T> collectIntoUnmodifiableCompatibleWithCollectionType(Class<?> typeOfCollection, Stream<? extends T> elementStream) {
        if (SortedSet.class.equals(typeOfCollection)) {
            return Collections.unmodifiableSortedSet(elementStream.collect(Collectors.toCollection(TreeSet::new)));
        }
        if (Set.class.equals(typeOfCollection)) {
            return Collections.unmodifiableSet(elementStream.collect(Collectors.toCollection(HashSet::new)));
        }
        if (List.class.equals(typeOfCollection)) {
            return Collections.unmodifiableList(elementStream.collect(Collectors.toCollection(ArrayList::new)));
        }
        if (Collection.class.equals(typeOfCollection)) {
            return Collections.unmodifiableCollection(elementStream.collect(Collectors.toCollection(ArrayList::new)));
        }
        throw new IllegalArgumentException(String.format("Can not collect into %s. Only List, Set, SortedSet and Collection are supported.", typeOfCollection.getClass().getName()));
    }
}

