/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.progmodel;

import java.util.List;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facets.FacetFactory;

public interface FacetFactorySet {
    public static final String FACET_FACTORY_INCLUDE_CLASS_NAME_LIST = "isis.reflector.facets.include";
    public static final String FACET_FACTORY_EXCLUDE_CLASS_NAME_LIST = "isis.reflector.facets.exclude";

    public List<FacetFactory> getList();

    public void addFactory(Class<? extends FacetFactory> var1);

    public void addFactory(FacetFactory var1);

    public void addFactory(Class<? extends FacetFactory> var1, Position var2);

    public void addFactory(FacetFactory var1, Position var2);

    public void removeFactory(Class<? extends FacetFactory> var1);

    public static class Util {
        private Util() {
        }

        public static void includeFacetFactories(IsisConfiguration configuration, FacetFactorySet programmingModel) {
            String[] facetFactoriesIncludeClassNames = configuration.getList(FacetFactorySet.FACET_FACTORY_INCLUDE_CLASS_NAME_LIST);
            if (facetFactoriesIncludeClassNames != null) {
                for (String facetFactoryClassName : facetFactoriesIncludeClassNames) {
                    Class facetFactory = InstanceUtil.loadClass(facetFactoryClassName, FacetFactory.class);
                    programmingModel.addFactory(facetFactory);
                }
            }
        }

        public static void excludeFacetFactories(IsisConfiguration configuration, FacetFactorySet programmingModel) {
            String[] facetFactoriesExcludeClassNames;
            for (String facetFactoryClassName : facetFactoriesExcludeClassNames = configuration.getList(FacetFactorySet.FACET_FACTORY_EXCLUDE_CLASS_NAME_LIST)) {
                Class facetFactory = InstanceUtil.loadClass(facetFactoryClassName, FacetFactory.class);
                programmingModel.removeFactory(facetFactory);
            }
        }
    }

    public static enum Position {
        BEGINNING,
        END;

    }
}

