/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.integer;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.integer.IntegerValueFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class IntValueSemanticsProviderAbstract
extends ValueSemanticsProviderAndFacetAbstract<Integer>
implements IntegerValueFacet {
    private static final Integer DEFAULT_VALUE = 0;
    private static final int MAX_LENGTH = 9;
    private static final int TYPICAL_LENGTH = 9;
    private final NumberFormat format = this.determineNumberFormat("value.format.int");

    public static Class<? extends Facet> type() {
        return IntegerValueFacet.class;
    }

    public IntValueSemanticsProviderAbstract(FacetHolder holder, Class<Integer> adaptedClass, ServicesInjector context) {
        super(IntValueSemanticsProviderAbstract.type(), holder, adaptedClass, 9, 9, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
    }

    @Override
    protected Integer doParse(Object context, String entry) {
        try {
            return this.format.parse(entry).intValue();
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not an whole number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Integer doRestore(String data) {
        return new Integer(data);
    }

    @Override
    public Integer integerValue(ObjectAdapter object) {
        return (Integer)(object == null ? null : object.getPojo());
    }

    @Override
    public ObjectAdapter createValue(Integer value) {
        return value == null ? null : this.getObjectAdapterProvider().adapterFor(value);
    }

    @Override
    public String toString() {
        return "IntegerValueSemanticsProvider: " + this.format;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("format", this.format);
    }
}

