/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejodalocal;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.value.JodaFunctions;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;

public final class JodaLocalDateTimeUtil {
    private JodaLocalDateTimeUtil() {
    }

    static LocalDateTime parseDate(String dateStr, List<DateTimeFormatter> parseFormatters) {
        Locale locale = Locale.getDefault();
        List elements = _Lists.map(parseFormatters, JodaFunctions.withLocale(locale));
        return JodaLocalDateTimeUtil.parseDateTime(dateStr, elements);
    }

    private static LocalDateTime parseDateTime(String dateStr, Iterable<DateTimeFormatter> formatters) {
        for (DateTimeFormatter formatter : formatters) {
            try {
                return formatter.parseLocalDateTime(dateStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new TextEntryParseException("Not recognised as a date: " + dateStr);
    }

    static LocalDateTime relativeDateTime(LocalDateTime contextDate, String str, boolean add) {
        LocalDateTime relativeDate = contextDate;
        if (str.equals("")) {
            return contextDate;
        }
        try {
            StringTokenizer st = new StringTokenizer(str.substring(1), " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                relativeDate = JodaLocalDateTimeUtil.adjustDateTime(relativeDate, token, add);
            }
            return relativeDate;
        }
        catch (Exception e) {
            return contextDate;
        }
    }

    private static LocalDateTime adjustDateTime(LocalDateTime contextDateTime, String str, boolean add) {
        int hours = 0;
        int minutes = 0;
        int days = 0;
        int months = 0;
        int years = 0;
        if (str.endsWith("H")) {
            str = str.substring(0, str.length() - 1);
            hours = Integer.valueOf(str);
        } else if (str.endsWith("M")) {
            str = str.substring(0, str.length() - 1);
            minutes = Integer.valueOf(str);
        } else if (str.endsWith("w")) {
            str = str.substring(0, str.length() - 1);
            days = 7 * Integer.valueOf(str);
        } else if (str.endsWith("y")) {
            str = str.substring(0, str.length() - 1);
            years = Integer.valueOf(str);
        } else if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            months = Integer.valueOf(str);
        } else if (str.endsWith("d")) {
            str = str.substring(0, str.length() - 1);
            days = Integer.valueOf(str);
        } else {
            days = Integer.valueOf(str);
        }
        if (add) {
            return JodaLocalDateTimeUtil.add(contextDateTime, years, months, days, hours, minutes);
        }
        return JodaLocalDateTimeUtil.add(contextDateTime, -years, -months, -days, -hours, -minutes);
    }

    private static LocalDateTime add(LocalDateTime original, int years, int months, int days, int hours, int minutes) {
        return original.plusYears(years).plusMonths(months).plusDays(days).plusHours(hours).plusMinutes(minutes);
    }

    public static String titleString(DateTimeFormatter formatter, LocalDateTime date) {
        return date == null ? "" : formatter.print((ReadablePartial)date);
    }
}

