/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejoda;

import java.util.Date;
import org.apache.isis.applib.adapters.EncodingException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.value.datetimejoda.JodaDateTimeValueSemanticsProviderAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaDateTimeValueSemanticsProvider
extends JodaDateTimeValueSemanticsProviderAbstract<DateTime> {
    private static final DateTime DEFAULT_VALUE = null;
    private final DateTimeFormatter encodingFormatter = ISODateTimeFormat.basicDateTime();

    public JodaDateTimeValueSemanticsProvider() {
        this(null, null);
    }

    public JodaDateTimeValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(holder, DateTime.class, DEFAULT_VALUE, context);
    }

    @Override
    protected DateTime add(DateTime original, int years, int months, int days, int hours, int minutes) {
        if (hours != 0 || minutes != 0) {
            throw new IllegalArgumentException("cannot add non-zero hours or minutes to a DateTime");
        }
        return original.plusYears(years).plusMonths(months).plusDays(days);
    }

    @Override
    protected DateTime now() {
        return new DateTime();
    }

    @Override
    protected Date dateValue(Object value) {
        return ((DateTime)value).toDateTime().toDate();
    }

    @Override
    protected DateTime setDate(Date date) {
        return new DateTime(date.getTime());
    }

    @Override
    protected String doEncode(Object object) {
        DateTime date = (DateTime)object;
        return this.encode(date);
    }

    private synchronized String encode(DateTime date) {
        return this.encodingFormatter.print((ReadableInstant)date);
    }

    @Override
    protected DateTime doRestore(String data) {
        try {
            return this.parse(data);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException((Throwable)e);
        }
    }

    private synchronized DateTime parse(String data) {
        return this.encodingFormatter.parseDateTime(data);
    }
}

