/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datetimejdk8local;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.adapters.EncodingException;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.facets.value.datetimejdk8local.Jdk8LocalDateTimeUtil;
import org.apache.isis.core.metamodel.facets.value.datetimejdk8local.Jdk8LocalDateTimeValueFacet;
import org.apache.isis.core.metamodel.facets.value.datetimejdk8local.TimeFormatter;
import org.apache.isis.core.metamodel.facets.value.datetimejdk8local.TimeParser;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

public class Jdk8LocalDateTimeValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<LocalDateTime>
implements Jdk8LocalDateTimeValueFacet {
    public static final int MAX_LENGTH = 36;
    public static final int TYPICAL_LENGTH = 22;
    public static final String CFG_FORMAT_KEY = "isis.value.format.datetime";
    private static Map<String, TimeFormatter> NAMED_TITLE_FORMATTERS = _Maps.newHashMap();
    private static final ThreadLocal<String> OVERRIDE_TITLE_PATTERN;
    private static final List<TimeParser> PARSE_FORMATTERS;
    private static final LocalDateTime DEFAULT_VALUE;
    private final TimeParser encodingParser = Jdk8LocalDateTimeUtil.parserOf(ISODateTimeFormat.dateHourMinuteSecondMillis());
    private final TimeFormatter encodingFormatter = Jdk8LocalDateTimeUtil.formatterOf(ISODateTimeFormat.dateHourMinuteSecondMillis());
    private TimeFormatter titleStringFormatter;
    private String titleStringFormatNameOrPattern;

    @Deprecated
    public static void setFormat(String propertyType, String pattern) {
        Jdk8LocalDateTimeValueSemanticsProvider.setTitlePatternOverride(pattern);
    }

    public static void setTitlePatternOverride(String pattern) {
        OVERRIDE_TITLE_PATTERN.set(pattern);
    }

    public static Class<? extends Facet> type() {
        return Jdk8LocalDateTimeValueFacet.class;
    }

    public Jdk8LocalDateTimeValueSemanticsProvider() {
        this(null, null);
    }

    public Jdk8LocalDateTimeValueSemanticsProvider(FacetHolder holder, ServicesInjector context) {
        super(Jdk8LocalDateTimeValueSemanticsProvider.type(), holder, LocalDateTime.class, 22, 36, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, context);
        String configuredNameOrPattern = this.getConfiguration().getString(CFG_FORMAT_KEY, "medium").toLowerCase().trim();
        this.updateTitleStringFormatter(configuredNameOrPattern);
    }

    private void updateTitleStringFormatter(String titleStringFormatNameOrPattern) {
        this.titleStringFormatter = NAMED_TITLE_FORMATTERS.get(titleStringFormatNameOrPattern);
        if (this.titleStringFormatter == null) {
            this.titleStringFormatter = DateTimeFormatter.ofPattern(titleStringFormatNameOrPattern)::format;
        }
        this.titleStringFormatNameOrPattern = titleStringFormatNameOrPattern;
    }

    @Override
    protected LocalDateTime doParse(String entry, Object context) {
        this.updateTitleStringFormatterIfOverridden();
        LocalDateTime contextDateTime = (LocalDateTime)context;
        String dateString = entry.trim().toUpperCase();
        if (dateString.startsWith("+") && contextDateTime != null) {
            return Jdk8LocalDateTimeUtil.relativeDateTime(contextDateTime, dateString, true);
        }
        if (dateString.startsWith("-") && contextDateTime != null) {
            return Jdk8LocalDateTimeUtil.relativeDateTime(contextDateTime, dateString, false);
        }
        return this.parseDateTime(dateString, contextDateTime);
    }

    private void updateTitleStringFormatterIfOverridden() {
        String overridePattern = OVERRIDE_TITLE_PATTERN.get();
        if (overridePattern == null || this.titleStringFormatNameOrPattern.equals(overridePattern)) {
            return;
        }
        this.updateTitleStringFormatter(overridePattern);
    }

    private LocalDateTime parseDateTime(String dateStr, Object original) {
        return Jdk8LocalDateTimeUtil.parseDate(dateStr, PARSE_FORMATTERS);
    }

    @Override
    public String titleString(Object value) {
        if (value == null) {
            return null;
        }
        LocalDateTime dateTime = (LocalDateTime)value;
        return Jdk8LocalDateTimeUtil.titleString(this.titleStringFormatter, dateTime);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        LocalDateTime dateTime = (LocalDateTime)value;
        return Jdk8LocalDateTimeUtil.titleString(DateTimeFormatter.ofPattern(usingMask)::format, dateTime);
    }

    @Override
    protected String doEncode(Object object) {
        LocalDateTime date = (LocalDateTime)object;
        return this.encode(date);
    }

    private synchronized String encode(LocalDateTime date) {
        return (String)this.encodingFormatter.apply(date);
    }

    @Override
    protected LocalDateTime doRestore(String data) {
        try {
            return this.parse(data);
        }
        catch (IllegalArgumentException e) {
            throw new EncodingException((Throwable)e);
        }
    }

    private synchronized LocalDateTime parse(String data) {
        return (LocalDateTime)this.encodingParser.apply(data);
    }

    @Override
    public final LocalDateTime dateValue(ObjectAdapter object) {
        return (LocalDateTime)(object == null ? null : object.getPojo());
    }

    @Override
    public final ObjectAdapter createValue(LocalDateTime date) {
        return this.getObjectAdapterProvider().adapterFor(date);
    }

    @Override
    public String toString() {
        return "Jdk8LocalDateTimeValueSemanticsProvider: " + this.titleStringFormatter;
    }

    static {
        NAMED_TITLE_FORMATTERS.put("iso_encoding", Jdk8LocalDateTimeUtil.formatterOf(ISODateTimeFormat.basicDateTime()));
        NAMED_TITLE_FORMATTERS.put("iso", Jdk8LocalDateTimeUtil.formatterOf(ISODateTimeFormat.basicDateTimeNoMillis()));
        NAMED_TITLE_FORMATTERS.put("long", Jdk8LocalDateTimeUtil.formatterOf(DateTimeFormat.forStyle((String)"LL")));
        NAMED_TITLE_FORMATTERS.put("medium", Jdk8LocalDateTimeUtil.formatterOf(DateTimeFormat.forStyle((String)"MM")));
        NAMED_TITLE_FORMATTERS.put("short", Jdk8LocalDateTimeUtil.formatterOf(DateTimeFormat.forStyle((String)"SS")));
        OVERRIDE_TITLE_PATTERN = new ThreadLocal<String>(){

            @Override
            protected String initialValue() {
                return null;
            }
        };
        PARSE_FORMATTERS = _Lists.newArrayList();
        PARSE_FORMATTERS.add(Jdk8LocalDateTimeUtil.parserOf(DateTimeFormat.forStyle((String)"LL")));
        PARSE_FORMATTERS.add(Jdk8LocalDateTimeUtil.parserOf(DateTimeFormat.forStyle((String)"MM")));
        PARSE_FORMATTERS.add(Jdk8LocalDateTimeUtil.parserOf(DateTimeFormat.forStyle((String)"SS")));
        PARSE_FORMATTERS.add(Jdk8LocalDateTimeUtil.parserOf(ISODateTimeFormat.basicDateTimeNoMillis()));
        PARSE_FORMATTERS.add(Jdk8LocalDateTimeUtil.parserOf(ISODateTimeFormat.basicDateTime()));
        DEFAULT_VALUE = null;
    }
}

