/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.value.datejdk8local;

import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.value.datejdk8local.TimeFormatter;
import org.apache.isis.core.metamodel.facets.value.datejdk8local.TimeParser;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

final class Jdk8LocalDateUtil {
    private Jdk8LocalDateUtil() {
    }

    static TimeParser parserOfStyle(String style) {
        return Jdk8LocalDateUtil.parserOf(DateTimeFormat.forStyle((String)style));
    }

    private static TimeParser parserOf(DateTimeFormatter jodaFormatter) {
        return t -> Jdk8LocalDateUtil.toJava8(jodaFormatter.withLocale(Locale.getDefault()).parseLocalDate(t));
    }

    private static LocalDate toJava8(org.joda.time.LocalDate x) {
        return LocalDate.of(x.getYear(), x.getMonthOfYear(), x.getDayOfMonth());
    }

    static TimeFormatter formatterOfStyle(String style) {
        return Jdk8LocalDateUtil.formatterOf(DateTimeFormat.forStyle((String)style));
    }

    private static TimeFormatter formatterOf(DateTimeFormatter jodaFormatter) {
        return t -> jodaFormatter.withLocale(Locale.getDefault()).print((ReadablePartial)Jdk8LocalDateUtil.toJoda(t));
    }

    private static org.joda.time.LocalDate toJoda(LocalDate x) {
        return new org.joda.time.LocalDate(x.getYear(), x.getMonthValue(), x.getDayOfMonth());
    }

    static TimeFormatter formatterOf(java.time.format.DateTimeFormatter formatter) {
        return t -> formatter.withLocale(Locale.getDefault()).format((TemporalAccessor)t);
    }

    static TimeParser parserOf(java.time.format.DateTimeFormatter formatter) {
        return text -> LocalDate.parse(text, formatter.withLocale(Locale.getDefault()));
    }

    static LocalDate parseDate(String dateStr, List<TimeParser> parsers) {
        LocalDate parsedDate = Jdk8LocalDateUtil._parseDate(dateStr, parsers);
        return parsedDate;
    }

    private static LocalDate _parseDate(String dateStr, Iterable<TimeParser> parsers) {
        for (TimeParser parser : parsers) {
            try {
                return (LocalDate)parser.apply(dateStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new TextEntryParseException("Not recognised as a date: " + dateStr);
    }

    static LocalDate relativeDate(LocalDate contextDate, String str, boolean add) {
        LocalDate relativeDate = contextDate;
        if (str.equals("")) {
            return contextDate;
        }
        try {
            StringTokenizer st = new StringTokenizer(str.substring(1), " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                relativeDate = Jdk8LocalDateUtil.adjustDate(relativeDate, token, add);
            }
            return relativeDate;
        }
        catch (Exception e) {
            return contextDate;
        }
    }

    private static LocalDate adjustDate(LocalDate contextDate, String str, boolean add) {
        int hours = 0;
        int minutes = 0;
        int days = 0;
        int months = 0;
        int years = 0;
        if (str.endsWith("H")) {
            str = str.substring(0, str.length() - 1);
            hours = Integer.valueOf(str);
        } else if (str.endsWith("M")) {
            str = str.substring(0, str.length() - 1);
            minutes = Integer.valueOf(str);
        } else if (str.endsWith("w")) {
            str = str.substring(0, str.length() - 1);
            days = 7 * Integer.valueOf(str);
        } else if (str.endsWith("y")) {
            str = str.substring(0, str.length() - 1);
            years = Integer.valueOf(str);
        } else if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            months = Integer.valueOf(str);
        } else if (str.endsWith("d")) {
            str = str.substring(0, str.length() - 1);
            days = Integer.valueOf(str);
        } else {
            days = Integer.valueOf(str);
        }
        if (add) {
            return Jdk8LocalDateUtil.add(contextDate, years, months, days, hours, minutes);
        }
        return Jdk8LocalDateUtil.add(contextDate, -years, -months, -days, -hours, -minutes);
    }

    private static LocalDate add(LocalDate original, int years, int months, int days, int hours, int minutes) {
        if (hours != 0 || minutes != 0) {
            throw new IllegalArgumentException("cannot add non-zero hours or minutes to a LocalDate");
        }
        return original.plusYears(years).plusMonths(months).plusDays(days);
    }

    public static String titleString(TimeFormatter formatter, LocalDate date) {
        return date == null ? "" : (String)formatter.apply(date);
    }
}

