/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.validating.method;

import java.lang.reflect.Method;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.properties.validating.method.PropertyValidateFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class PropertyValidateFacetViaMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"validate"};

    public PropertyValidateFacetViaMethodFactory() {
        super(FeatureType.PROPERTIES_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachValidateFacetIfValidateMethodIsFound(processMethodContext);
    }

    private void attachValidateFacetIfValidateMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> returnType = getMethod.getReturnType();
        Class[] paramTypes = new Class[]{returnType};
        Class<?> cls = processMethodContext.getCls();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "validate" + capitalizedName, new Class[]{String.class, TranslatableString.class}, paramTypes);
        if (method == null) {
            return;
        }
        processMethodContext.removeMethod(method);
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        TranslationService translationService = this.servicesInjector.lookupService(TranslationService.class).orElse(null);
        String translationContext = facetHolder.getIdentifier().toClassAndNameIdentityString();
        PropertyValidateFacetViaMethod facet = new PropertyValidateFacetViaMethod(method, translationService, translationContext, facetHolder);
        FacetUtil.addFacet(facet);
    }
}

