/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.regex;

import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacetAbstract;

public class RegExFacetForPatternAnnotationOnProperty
extends RegExFacetAbstract {
    private final java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(this.regexp(), this.patternFlags());

    public static RegExFacet create(List<Pattern> patterns, Class<?> returnType, FacetHolder holder) {
        if (!Annotations.isString(returnType)) {
            return null;
        }
        return patterns.stream().filter(pattern -> _Strings.emptyToNull((String)pattern.regexp()) != null).findFirst().map(pattern -> new RegExFacetForPatternAnnotationOnProperty(pattern.regexp(), pattern.flags(), pattern.message(), holder)).orElse(null);
    }

    private RegExFacetForPatternAnnotationOnProperty(String regexp, Pattern.Flag[] flags, String replacement, FacetHolder holder) {
        super(regexp, flags, replacement, holder);
    }

    @Override
    public boolean doesNotMatch(String text) {
        if (text == null) {
            return true;
        }
        return !this.pattern.matcher(text).matches();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("pattern", this.pattern);
    }
}

