/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.disabled;

import java.util.List;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetAbstractImpl;
import org.apache.isis.core.metamodel.facets.properties.property.disabled.DisabledFacetForPropertyAnnotationInvertedSemantics;

public class DisabledFacetForPropertyAnnotation
extends DisabledFacetAbstractImpl {
    public static DisabledFacet create(List<Property> properties, FacetHolder holder) {
        return properties.stream().filter(property -> property.editing() != Editing.NOT_SPECIFIED).findFirst().map(property -> {
            switch (property.editing()) {
                case AS_CONFIGURED: {
                    return null;
                }
                case DISABLED: {
                    String disabledReason = property.editingDisabledReason();
                    return new DisabledFacetForPropertyAnnotation(disabledReason, holder);
                }
                case ENABLED: {
                    return new DisabledFacetForPropertyAnnotationInvertedSemantics(holder);
                }
            }
            return null;
        }).orElse(null);
    }

    private DisabledFacetForPropertyAnnotation(String reason, FacetHolder holder) {
        super(Where.EVERYWHERE, reason, holder);
    }
}

