/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property;

import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.events.domain.PropertyDomainEvent;
import org.apache.isis.applib.services.HasUniqueId;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.PropertyDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.objectvalue.fileaccept.FileAcceptFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacet;
import org.apache.isis.core.metamodel.facets.properties.projection.ProjectingFacet;
import org.apache.isis.core.metamodel.facets.properties.projection.ProjectingFacetFromPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.command.CommandFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.disabled.DisabledFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.fileaccept.FileAcceptFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.hidden.HiddenFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.mandatory.MandatoryFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.mandatory.MandatoryFacetInvertedByNullableAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.maxlength.MaxLengthFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyClearFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyClearFacetForDomainEventFromPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetDefault;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertyDomainEventFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterFacetForDomainEventFromPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.modify.PropertySetterOrClearFacetForDomainEventAbstract;
import org.apache.isis.core.metamodel.facets.properties.property.mustsatisfy.MustSatisfySpecificationFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.notpersisted.NotPersistedFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.publishing.PublishedPropertyFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.property.regex.RegExFacetForPatternAnnotationOnProperty;
import org.apache.isis.core.metamodel.facets.properties.property.regex.RegExFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.facets.properties.publish.PublishedPropertyFacet;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForConflictingOptionality;
import org.apache.isis.core.metamodel.util.EventUtil;

public class PropertyAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private final MetaModelValidatorForConflictingOptionality conflictingOptionalityValidator = new MetaModelValidatorForConflictingOptionality();

    public PropertyAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.processModify(processMethodContext);
        this.processHidden(processMethodContext);
        this.processEditing(processMethodContext);
        this.processCommand(processMethodContext);
        this.processProjecting(processMethodContext);
        this.processPublishing(processMethodContext);
        this.processMaxLength(processMethodContext);
        this.processMustSatisfy(processMethodContext);
        this.processNotPersisted(processMethodContext);
        this.processOptional(processMethodContext);
        this.processRegEx(processMethodContext);
        this.processFileAccept(processMethodContext);
    }

    void processModify(FacetFactory.ProcessMethodContext processMethodContext) {
        PropertyClearFacet clearFacet;
        PropertySetterFacet setterFacet;
        Method method = processMethodContext.getMethod();
        Class<?> cls = processMethodContext.getCls();
        ObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(cls);
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        PropertyOrCollectionAccessorFacet getterFacet = holder.getFacet(PropertyOrCollectionAccessorFacet.class);
        if (getterFacet == null) {
            return;
        }
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        PropertyDomainEventFacetAbstract propertyDomainEventFacet = properties.stream().map(Property::domainEvent).filter(domainEvent -> domainEvent != PropertyDomainEvent.Default.class).findFirst().map(domainEvent -> new PropertyDomainEventFacetForPropertyAnnotation(PropertyAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, domainEvent), getterFacet, this.servicesInjector, this.getSpecificationLoader(), holder)).orElse(new PropertyDomainEventFacetDefault(PropertyAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, PropertyDomainEvent.Default.class), getterFacet, this.servicesInjector, this.getSpecificationLoader(), holder));
        if (EventUtil.eventTypeIsPostable(propertyDomainEventFacet.getEventType(), PropertyDomainEvent.Noop.class, PropertyDomainEvent.Default.class, "isis.reflector.facet.propertyAnnotation.domainEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(propertyDomainEventFacet);
        }
        if ((setterFacet = holder.getFacet(PropertySetterFacet.class)) != null) {
            PropertySetterOrClearFacetForDomainEventAbstract replacementFacet = propertyDomainEventFacet instanceof PropertyDomainEventFacetForPropertyAnnotation ? new PropertySetterFacetForDomainEventFromPropertyAnnotation(propertyDomainEventFacet.getEventType(), getterFacet, setterFacet, propertyDomainEventFacet, holder, this.servicesInjector) : new PropertySetterFacetForDomainEventFromDefault(propertyDomainEventFacet.getEventType(), getterFacet, setterFacet, propertyDomainEventFacet, holder, this.servicesInjector);
            FacetUtil.addFacet(replacementFacet);
        }
        if ((clearFacet = holder.getFacet(PropertyClearFacet.class)) != null) {
            PropertySetterOrClearFacetForDomainEventAbstract replacementFacet = propertyDomainEventFacet instanceof PropertyDomainEventFacetForPropertyAnnotation ? new PropertyClearFacetForDomainEventFromPropertyAnnotation(propertyDomainEventFacet.getEventType(), getterFacet, clearFacet, propertyDomainEventFacet, holder, this.servicesInjector) : new PropertyClearFacetForDomainEventFromDefault(propertyDomainEventFacet.getEventType(), getterFacet, clearFacet, propertyDomainEventFacet, holder, this.servicesInjector);
            FacetUtil.addFacet(replacementFacet);
        }
    }

    public static Class<? extends PropertyDomainEvent<?, ?>> defaultFromDomainObjectIfRequired(ObjectSpecification typeSpec, Class<? extends PropertyDomainEvent<?, ?>> propertyDomainEventType) {
        PropertyDomainEventDefaultFacetForDomainObjectAnnotation typeFromDomainObject;
        if (propertyDomainEventType == PropertyDomainEvent.Default.class && (typeFromDomainObject = typeSpec.getFacet(PropertyDomainEventDefaultFacetForDomainObjectAnnotation.class)) != null) {
            return typeFromDomainObject.getEventType();
        }
        return propertyDomainEventType;
    }

    void processHidden(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        HiddenFacet facet = HiddenFacetForPropertyAnnotation.create(properties, holder);
        FacetUtil.addFacet(facet);
    }

    void processEditing(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        DisabledFacet facet = DisabledFacetForPropertyAnnotation.create(properties, holder);
        FacetUtil.addFacet(facet);
    }

    void processCommand(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetHolder;
        Method method = processMethodContext.getMethod();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        FacetedMethod holder = facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        if (HasUniqueId.class.isAssignableFrom(processMethodContext.getCls())) {
            return;
        }
        CommandFacet commandFacet = CommandFacetForPropertyAnnotation.create(properties, this.getConfiguration(), holder, this.servicesInjector);
        FacetUtil.addFacet(commandFacet);
    }

    void processProjecting(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> cls = processMethodContext.getCls();
        Method method = processMethodContext.getMethod();
        Property property = Annotations.getAnnotation(method, Property.class);
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        ProjectingFacet projectingFacet = ProjectingFacetFromPropertyAnnotation.create(property, facetHolder);
        FacetUtil.addFacet(projectingFacet);
    }

    void processPublishing(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        Object holder = processMethodContext.getFacetHolder();
        if (HasUniqueId.class.isAssignableFrom(processMethodContext.getCls())) {
            return;
        }
        PublishedPropertyFacet facet = PublishedPropertyFacetForPropertyAnnotation.create(properties, this.getConfiguration(), holder);
        FacetUtil.addFacet(facet);
    }

    void processMaxLength(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        MaxLengthFacet facet = MaxLengthFacetForPropertyAnnotation.create(properties, holder);
        FacetUtil.addFacet(facet);
    }

    void processMustSatisfy(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        Facet facet = MustSatisfySpecificationFacetForPropertyAnnotation.create(properties, holder, this.servicesInjector);
        FacetUtil.addFacet(facet);
    }

    void processNotPersisted(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        NotPersistedFacet facet = NotPersistedFacetForPropertyAnnotation.create(properties, holder);
        FacetUtil.addFacet(facet);
    }

    void processOptional(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Nullable> nullableAnnotations = Annotations.getAnnotations(method, Nullable.class);
        Nullable nullableAnnotation = nullableAnnotations.isEmpty() ? null : nullableAnnotations.get(0);
        MandatoryFacet facet2 = MandatoryFacetInvertedByNullableAnnotationOnProperty.create(nullableAnnotation, method, holder);
        FacetUtil.addFacet(facet2);
        this.conflictingOptionalityValidator.flagIfConflict(facet2, "Conflicting @Nullable with other optionality annotation");
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        MandatoryFacet facet3 = MandatoryFacetForPropertyAnnotation.create(properties, method, holder);
        FacetUtil.addFacet(facet3);
        this.conflictingOptionalityValidator.flagIfConflict(facet3, "Conflicting Property#optionality with other optionality annotation");
    }

    void processRegEx(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        List<Pattern> patterns = Annotations.getAnnotations(processMethodContext.getMethod(), Pattern.class);
        RegExFacet facet = RegExFacetForPatternAnnotationOnProperty.create(patterns, returnType, holder);
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        if (facet == null) {
            facet = RegExFacetForPropertyAnnotation.create(properties, returnType, holder);
        }
        FacetUtil.addFacet(facet);
    }

    void processFileAccept(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Property> properties = Annotations.getAnnotations(method, Property.class);
        FileAcceptFacet facet = FileAcceptFacetForPropertyAnnotation.create(properties, holder);
        FacetUtil.addFacet(facet);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(this.conflictingOptionalityValidator);
    }
}

