/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.defaults.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class PropertyDefaultFacetViaMethod
extends PropertyDefaultFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final SpecificationLoader specificationLoader;
    private final ObjectAdapterProvider adapterProvider;

    public PropertyDefaultFacetViaMethod(Method method, FacetHolder holder, SpecificationLoader specificationLoader, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.method = method;
        this.specificationLoader = specificationLoader;
        this.adapterProvider = adapterProvider;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.DEFAULTS;
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter owningAdapter) {
        Object result = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (result == null) {
            return null;
        }
        return this.createAdapter(this.method.getReturnType(), result);
    }

    private ObjectAdapter createAdapter(Class<?> type, Object object) {
        ObjectSpecification specification = this.getSpecificationLoader().loadSpecification(type);
        if (specification.isNotCollection()) {
            return this.getObjectAdapterProvider().adapterFor(object);
        }
        throw new UnknownTypeException("not an object, is this a collection?");
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

