/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.autocomplete.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.properties.autocomplete.method.PropertyAutoCompleteFacetMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class PropertyAutoCompleteFacetMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"autoComplete"};
    ObjectAdapterProvider adapterProvider;

    public PropertyAutoCompleteFacetMethodFactory() {
        super(FeatureType.PROPERTIES_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachPropertyAutoCompleteFacetIfChoicesMethodIsFound(processMethodContext);
    }

    private void attachPropertyAutoCompleteFacetIfChoicesMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Class<?> returnType = getMethod.getReturnType();
        Method autoCompleteMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "autoComplete" + capitalizedName, (Class)null, new Class[]{String.class});
        if (autoCompleteMethod == null) {
            return;
        }
        processMethodContext.removeMethod(autoCompleteMethod);
        Object property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new PropertyAutoCompleteFacetMethod(autoCompleteMethod, returnType, (FacetHolder)property, this.getSpecificationLoader(), this.getAuthenticationSessionProvider(), this.adapterProvider));
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterProvider = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

